@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * VolumeClaimDataSource properties
 * @property apiGroup APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
 * @property kind Kind is the type of resource being referenced
 * @property name Name is the name of resource being referenced
 */
public data class VolumeClaimDataSourceResponse(
    public val apiGroup: String? = null,
    public val kind: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.VolumeClaimDataSourceResponse): VolumeClaimDataSourceResponse = VolumeClaimDataSourceResponse(
            apiGroup = javaType.apiGroup().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind(),
            name = javaType.name(),
        )
    }
}
