@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * VolumeClaimSpec properties
 * @property accessModes AccessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
 * @property dataSource This field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source. If the AnyVolumeDataSource feature gate is enabled, this field will always have the same contents as the DataSourceRef field.
 * @property dataSourceRef Specifies the object from which to populate the volume with data, if a non-empty volume is desired. This may be any local object from a non-empty API group (non core object) or a PersistentVolumeClaim object. When this field is specified, volume binding will only succeed if the type of the specified object matches some installed volume populator or dynamic provisioner. This field will replace the functionality of the DataSource field and as such if both fields are non-empty, they must have the same value. For backwards compatibility, both fields (DataSource and DataSourceRef) will be set to the same value automatically if one of them is empty and the other is non-empty. There are two important differences between DataSource and DataSourceRef: * While DataSource only allows two specific types of objects, DataSourceRef allows any non-core object, as well as PersistentVolumeClaim objects. * While DataSource ignores disallowed values (dropping them), DataSourceRef preserves all values, and generates an error if a disallowed value is specified. (Alpha) Using this field requires the AnyVolumeDataSource feature gate to be enabled.
 * @property resources Resources represents the minimum resources the volume should have. If RecoverVolumeExpansionFailure feature is enabled users are allowed to specify resource requirements that are lower than previous value but must still be higher than capacity recorded in the status field of the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
 * @property selector A label query over volumes to consider for binding.
 * @property storageClassName Name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
 * @property volumeMode volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec. This is a beta feature.
 * @property volumeName VolumeName is the binding reference to the PersistentVolume backing this claim.
 */
public data class VolumeClaimSpecResponse(
    public val accessModes: List<String>? = null,
    public val dataSource: VolumeClaimDataSourceResponse? = null,
    public val dataSourceRef: VolumeClaimDataSourceRefResponse? = null,
    public val resources: VolumeClaimResourceRequirementsResponse? = null,
    public val selector: VolumeClaimSpecSelectorResponse? = null,
    public val storageClassName: String? = null,
    public val volumeMode: String? = null,
    public val volumeName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.VolumeClaimSpecResponse): VolumeClaimSpecResponse = VolumeClaimSpecResponse(
            accessModes = javaType.accessModes().map({ args0 -> args0 }),
            dataSource = javaType.dataSource().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.VolumeClaimDataSourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataSourceRef = javaType.dataSourceRef().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.VolumeClaimDataSourceRefResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            resources = javaType.resources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.VolumeClaimResourceRequirementsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            selector = javaType.selector().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.VolumeClaimSpecSelectorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageClassName = javaType.storageClassName().map({ args0 -> args0 }).orElse(null),
            volumeMode = javaType.volumeMode().map({ args0 -> args0 }).orElse(null),
            volumeName = javaType.volumeName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
