@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * VolumeClaimSpecSelector properties
 * @property matchExpressions MatchExpressions is a list of label selector requirements. The requirements are ANDed.
 * @property matchLabels MatchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
 */
public data class VolumeClaimSpecSelectorResponse(
    public val matchExpressions: List<VolumeClaimSpecSelectorMatchExpressionsResponse>? = null,
    public val matchLabels: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.VolumeClaimSpecSelectorResponse): VolumeClaimSpecSelectorResponse = VolumeClaimSpecSelectorResponse(
            matchExpressions = javaType.matchExpressions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.VolumeClaimSpecSelectorMatchExpressionsResponse.Companion.toKotlin(args0)
                })
            }),
            matchLabels = javaType.matchLabels().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
