@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsorchestrator.kotlin

import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.ComponentPropertiesResponse
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.ComponentPropertiesResponse.Companion.toKotlin as componentPropertiesResponseToKotlin
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Solution].
 */
@PulumiTagMarker
public class SolutionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SolutionArgs = SolutionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SolutionArgsBuilder.() -> Unit) {
        val builder = SolutionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Solution {
        val builtJavaResource =
            com.pulumi.azurenative.iotoperationsorchestrator.Solution(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Solution(builtJavaResource)
    }
}

/**
 * A Solution resource belonging to an Instance resource.
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### Solutions_CreateOrUpdate - generated by [MaximumSet] rule - generated by [MaximumSet] rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var solution = new AzureNative.IoTOperationsOrchestrator.Solution("solution", new()
 *     {
 *         Components = new[]
 *         {
 *             new AzureNative.IoTOperationsOrchestrator.Inputs.ComponentPropertiesArgs
 *             {
 *                 Dependencies = new[]
 *                 {
 *                     "x",
 *                 },
 *                 Name = "yhnelpxsobdyurwvhkq",
 *                 Properties = null,
 *                 Type = "wiabwsfqhhxru",
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.IoTOperationsOrchestrator.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "bjjhfqsplgzdlbdlddleetyg",
 *             Type = "sosibrbmmrfbbyp",
 *         },
 *         Location = "svzwmojzvarczmvgfhjk",
 *         Name = "49-gj2-mwgt--1m611----35u",
 *         ResourceGroupName = "rgopenapi",
 *         Tags = null,
 *         Version = "jwxk",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsorchestrator/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsorchestrator.NewSolution(ctx, "solution", &iotoperationsorchestrator.SolutionArgs{
 * 			Components: iotoperationsorchestrator.ComponentPropertiesArray{
 * 				&iotoperationsorchestrator.ComponentPropertiesArgs{
 * 					Dependencies: pulumi.StringArray{
 * 						pulumi.String("x"),
 * 					},
 * 					Name:       pulumi.String("yhnelpxsobdyurwvhkq"),
 * 					Properties: pulumi.Any(nil),
 * 					Type:       pulumi.String("wiabwsfqhhxru"),
 * 				},
 * 			},
 * 			ExtendedLocation: &iotoperationsorchestrator.ExtendedLocationArgs{
 * 				Name: pulumi.String("bjjhfqsplgzdlbdlddleetyg"),
 * 				Type: pulumi.String("sosibrbmmrfbbyp"),
 * 			},
 * 			Location:          pulumi.String("svzwmojzvarczmvgfhjk"),
 * 			Name:              pulumi.String("49-gj2-mwgt--1m611----35u"),
 * 			ResourceGroupName: pulumi.String("rgopenapi"),
 * 			Tags:              nil,
 * 			Version:           pulumi.String("jwxk"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsorchestrator.Solution;
 * import com.pulumi.azurenative.iotoperationsorchestrator.SolutionArgs;
 * import com.pulumi.azurenative.iotoperationsorchestrator.inputs.ComponentPropertiesArgs;
 * import com.pulumi.azurenative.iotoperationsorchestrator.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var solution = new Solution("solution", SolutionArgs.builder()
 *             .components(ComponentPropertiesArgs.builder()
 *                 .dependencies("x")
 *                 .name("yhnelpxsobdyurwvhkq")
 *                 .properties()
 *                 .type("wiabwsfqhhxru")
 *                 .build())
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("bjjhfqsplgzdlbdlddleetyg")
 *                 .type("sosibrbmmrfbbyp")
 *                 .build())
 *             .location("svzwmojzvarczmvgfhjk")
 *             .name("49-gj2-mwgt--1m611----35u")
 *             .resourceGroupName("rgopenapi")
 *             .tags()
 *             .version("jwxk")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsorchestrator:Solution l /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsOrchestrator/solutions/{name}
 * ```
 */
public class Solution internal constructor(
    override val javaResource: com.pulumi.azurenative.iotoperationsorchestrator.Solution,
) : KotlinCustomResource(javaResource, SolutionMapper) {
    /**
     * A list of components
     */
    public val components: Output<List<ComponentPropertiesResponse>>?
        get() = javaResource.components().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> componentPropertiesResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Edge location of the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Version of the particular resource.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object SolutionMapper : ResourceMapper<Solution> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.iotoperationsorchestrator.Solution::class == javaResource::class

    override fun map(javaResource: Resource): Solution = Solution(
        javaResource as
            com.pulumi.azurenative.iotoperationsorchestrator.Solution,
    )
}

/**
 * @see [Solution].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Solution].
 */
public suspend fun solution(name: String, block: suspend SolutionResourceBuilder.() -> Unit): Solution {
    val builder = SolutionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Solution].
 * @param name The _unique_ name of the resulting resource.
 */
public fun solution(name: String): Solution {
    val builder = SolutionResourceBuilder()
    builder.name(name)
    return builder.build()
}
