@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs

import com.pulumi.azurenative.iotoperationsorchestrator.inputs.TopologiesPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines a desired runtime component.
 * @property bindings bindings description.
 */
public data class TopologiesPropertiesArgs(
    public val bindings: Output<List<BindingPropertiesArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsorchestrator.inputs.TopologiesPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsorchestrator.inputs.TopologiesPropertiesArgs =
        com.pulumi.azurenative.iotoperationsorchestrator.inputs.TopologiesPropertiesArgs.builder()
            .bindings(
                bindings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TopologiesPropertiesArgs].
 */
@PulumiTagMarker
public class TopologiesPropertiesArgsBuilder internal constructor() {
    private var bindings: Output<List<BindingPropertiesArgs>>? = null

    /**
     * @param value bindings description.
     */
    @JvmName("bsndnsgsmflquxip")
    public suspend fun bindings(`value`: Output<List<BindingPropertiesArgs>>) {
        this.bindings = value
    }

    @JvmName("ooqdkywfslifmxmm")
    public suspend fun bindings(vararg values: Output<BindingPropertiesArgs>) {
        this.bindings = Output.all(values.asList())
    }

    /**
     * @param values bindings description.
     */
    @JvmName("sreglroyakrpmxun")
    public suspend fun bindings(values: List<Output<BindingPropertiesArgs>>) {
        this.bindings = Output.all(values)
    }

    /**
     * @param value bindings description.
     */
    @JvmName("jkuxtsywhuvbsegh")
    public suspend fun bindings(`value`: List<BindingPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bindings = mapped
    }

    /**
     * @param argument bindings description.
     */
    @JvmName("crqmocixxaeqaupu")
    public suspend fun bindings(argument: List<suspend BindingPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BindingPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bindings = mapped
    }

    /**
     * @param argument bindings description.
     */
    @JvmName("yhurvmuohcmgrmjt")
    public suspend fun bindings(vararg argument: suspend BindingPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BindingPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bindings = mapped
    }

    /**
     * @param argument bindings description.
     */
    @JvmName("jashxljhhmexhoyd")
    public suspend fun bindings(argument: suspend BindingPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BindingPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.bindings = mapped
    }

    /**
     * @param values bindings description.
     */
    @JvmName("vwyaycqudhsbfmia")
    public suspend fun bindings(vararg values: BindingPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bindings = mapped
    }

    internal fun build(): TopologiesPropertiesArgs = TopologiesPropertiesArgs(
        bindings = bindings,
    )
}
