@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Defines a component binding for a provider.
 * @property config Configuration values for the binding.
 * @property provider Name of the provider.
 * @property role Role that the provider binds to with the component.
 */
public data class BindingPropertiesResponse(
    public val config: Any,
    public val provider: String,
    public val role: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsorchestrator.outputs.BindingPropertiesResponse): BindingPropertiesResponse = BindingPropertiesResponse(
            config = javaType.config(),
            provider = javaType.provider(),
            role = javaType.role(),
        )
    }
}
