@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A Instance resource belonging to an Instance resource.
 * @property extendedLocation Edge location of the resource.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState The status of the last operation.
 * @property reconciliationPolicy Reconciliation Policy.
 * @property scope Deployment scope (such as Kubernetes namespace).
 * @property solution Name of the solution.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property target Defines the Target the Instance will deploy to.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property version Version of the particular resource.
 */
public data class GetInstanceResult(
    public val extendedLocation: ExtendedLocationResponse,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val reconciliationPolicy: ReconciliationPolicyResponse? = null,
    public val scope: String? = null,
    public val solution: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val target: TargetSelectorPropertiesResponse? = null,
    public val type: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsorchestrator.outputs.GetInstanceResult): GetInstanceResult = GetInstanceResult(
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            reconciliationPolicy = javaType.reconciliationPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.ReconciliationPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            solution = javaType.solution().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            target = javaType.target().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.TargetSelectorPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
