@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin

import com.pulumi.azurenative.keyvault.AccessPolicyArgs.builder
import com.pulumi.azurenative.keyvault.kotlin.inputs.AccessPolicyEntryArgs
import com.pulumi.azurenative.keyvault.kotlin.inputs.AccessPolicyEntryArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Key Vault Access Policy for managing policies on existing vaults.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:keyvault:AccessPolicy myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/accessPolicy
 * ```
 * @property policy The definition of the access policy.
 * @property resourceGroupName Name of the resource group that contains the vault.
 * @property vaultName Name of the Key Vault.
 */
public data class AccessPolicyArgs(
    public val policy: Output<AccessPolicyEntryArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val vaultName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.AccessPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.AccessPolicyArgs =
        com.pulumi.azurenative.keyvault.AccessPolicyArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessPolicyArgs].
 */
@PulumiTagMarker
public class AccessPolicyArgsBuilder internal constructor() {
    private var policy: Output<AccessPolicyEntryArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var vaultName: Output<String>? = null

    /**
     * @param value The definition of the access policy.
     */
    @JvmName("ekmkssmiqakpcnou")
    public suspend fun policy(`value`: Output<AccessPolicyEntryArgs>) {
        this.policy = value
    }

    /**
     * @param value Name of the resource group that contains the vault.
     */
    @JvmName("axmxdubrbawkieju")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the Key Vault.
     */
    @JvmName("ufttcbbtjmaefogs")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value The definition of the access policy.
     */
    @JvmName("ofmwbynvlilwffdy")
    public suspend fun policy(`value`: AccessPolicyEntryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument The definition of the access policy.
     */
    @JvmName("kvxlqwfnbmgqhojp")
    public suspend fun policy(argument: suspend AccessPolicyEntryArgsBuilder.() -> Unit) {
        val toBeMapped = AccessPolicyEntryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value Name of the resource group that contains the vault.
     */
    @JvmName("posjcujxsqrxhhyf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the Key Vault.
     */
    @JvmName("rovprlmtbnaitvtc")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    internal fun build(): AccessPolicyArgs = AccessPolicyArgs(
        policy = policy,
        resourceGroupName = resourceGroupName,
        vaultName = vaultName,
    )
}
