@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin

import com.pulumi.azurenative.keyvault.KeyArgs.builder
import com.pulumi.azurenative.keyvault.kotlin.inputs.KeyPropertiesArgs
import com.pulumi.azurenative.keyvault.kotlin.inputs.KeyPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The key resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2019-09-01.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create a key
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var key = new AzureNative.KeyVault.Key("key", new()
 *     {
 *         KeyName = "sample-key-name",
 *         Properties = new AzureNative.KeyVault.Inputs.KeyPropertiesArgs
 *         {
 *             Kty = AzureNative.KeyVault.JsonWebKeyType.RSA,
 *         },
 *         ResourceGroupName = "sample-group",
 *         VaultName = "sample-vault-name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/keyvault/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := keyvault.NewKey(ctx, "key", &keyvault.KeyArgs{
 * 			KeyName: pulumi.String("sample-key-name"),
 * 			Properties: &keyvault.KeyPropertiesArgs{
 * 				Kty: pulumi.String(keyvault.JsonWebKeyTypeRSA),
 * 			},
 * 			ResourceGroupName: pulumi.String("sample-group"),
 * 			VaultName:         pulumi.String("sample-vault-name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.keyvault.Key;
 * import com.pulumi.azurenative.keyvault.KeyArgs;
 * import com.pulumi.azurenative.keyvault.inputs.KeyPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var key = new Key("key", KeyArgs.builder()
 *             .keyName("sample-key-name")
 *             .properties(KeyPropertiesArgs.builder()
 *                 .kty("RSA")
 *                 .build())
 *             .resourceGroupName("sample-group")
 *             .vaultName("sample-vault-name")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:keyvault:Key sample-key-name /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/keys/{keyName}
 * ```
 * @property keyName The name of the key to be created. The value you provide may be copied globally for the purpose of running the service. The value provided should not include personally identifiable or sensitive information.
 * @property properties The properties of the key to be created.
 * @property resourceGroupName The name of the resource group which contains the specified key vault.
 * @property tags The tags that will be assigned to the key.
 * @property vaultName The name of the key vault which contains the key to be created.
 */
public data class KeyArgs(
    public val keyName: Output<String>? = null,
    public val properties: Output<KeyPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vaultName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.KeyArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.KeyArgs =
        com.pulumi.azurenative.keyvault.KeyArgs.builder()
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyArgs].
 */
@PulumiTagMarker
public class KeyArgsBuilder internal constructor() {
    private var keyName: Output<String>? = null

    private var properties: Output<KeyPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vaultName: Output<String>? = null

    /**
     * @param value The name of the key to be created. The value you provide may be copied globally for the purpose of running the service. The value provided should not include personally identifiable or sensitive information.
     */
    @JvmName("asiuehcfcjyawwhs")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The properties of the key to be created.
     */
    @JvmName("xhlafbtvcrkhhppb")
    public suspend fun properties(`value`: Output<KeyPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group which contains the specified key vault.
     */
    @JvmName("cthvrelytcqmkhvj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tags that will be assigned to the key.
     */
    @JvmName("gjkfujvylojtwjqc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the key vault which contains the key to be created.
     */
    @JvmName("enwiiveomturbqei")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value The name of the key to be created. The value you provide may be copied globally for the purpose of running the service. The value provided should not include personally identifiable or sensitive information.
     */
    @JvmName("tbonabvwacntotog")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The properties of the key to be created.
     */
    @JvmName("dukmeialkepsgwcw")
    public suspend fun properties(`value`: KeyPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The properties of the key to be created.
     */
    @JvmName("vesrwkmifiweufka")
    public suspend fun properties(argument: suspend KeyPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group which contains the specified key vault.
     */
    @JvmName("aojolvnifriebibd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tags that will be assigned to the key.
     */
    @JvmName("aothkhrmvrfwxbhb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags that will be assigned to the key.
     */
    @JvmName("baecayqttxwchmgg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the key vault which contains the key to be created.
     */
    @JvmName("dagyhhjxnqguajpx")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    internal fun build(): KeyArgs = KeyArgs(
        keyName = keyName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vaultName = vaultName,
    )
}
