@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin

import com.pulumi.azurenative.keyvault.kotlin.outputs.ManagedHsmPropertiesResponse
import com.pulumi.azurenative.keyvault.kotlin.outputs.ManagedHsmSkuResponse
import com.pulumi.azurenative.keyvault.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.keyvault.kotlin.outputs.ManagedHsmPropertiesResponse.Companion.toKotlin as managedHsmPropertiesResponseToKotlin
import com.pulumi.azurenative.keyvault.kotlin.outputs.ManagedHsmSkuResponse.Companion.toKotlin as managedHsmSkuResponseToKotlin
import com.pulumi.azurenative.keyvault.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ManagedHsm].
 */
@PulumiTagMarker
public class ManagedHsmResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedHsmArgs = ManagedHsmArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedHsmArgsBuilder.() -> Unit) {
        val builder = ManagedHsmArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagedHsm {
        val builtJavaResource = com.pulumi.azurenative.keyvault.ManagedHsm(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ManagedHsm(builtJavaResource)
    }
}

/**
 * Resource information with extended details.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-06-01-preview.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create a new managed HSM Pool or update an existing managed HSM Pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedHsm = new AzureNative.KeyVault.ManagedHsm("managedHsm", new()
 *     {
 *         Location = "westus",
 *         Name = "hsm1",
 *         Properties = new AzureNative.KeyVault.Inputs.ManagedHsmPropertiesArgs
 *         {
 *             EnablePurgeProtection = false,
 *             EnableSoftDelete = true,
 *             InitialAdminObjectIds = new[]
 *             {
 *                 "00000000-0000-0000-0000-000000000000",
 *             },
 *             SoftDeleteRetentionInDays = 90,
 *             TenantId = "00000000-0000-0000-0000-000000000000",
 *         },
 *         ResourceGroupName = "hsm-group",
 *         Sku = new AzureNative.KeyVault.Inputs.ManagedHsmSkuArgs
 *         {
 *             Family = AzureNative.KeyVault.ManagedHsmSkuFamily.B,
 *             Name = AzureNative.KeyVault.ManagedHsmSkuName.Standard_B1,
 *         },
 *         Tags =
 *         {
 *             { "Dept", "hsm" },
 *             { "Environment", "dogfood" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/keyvault/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := keyvault.NewManagedHsm(ctx, "managedHsm", &keyvault.ManagedHsmArgs{
 * 			Location: pulumi.String("westus"),
 * 			Name:     pulumi.String("hsm1"),
 * 			Properties: &keyvault.ManagedHsmPropertiesArgs{
 * 				EnablePurgeProtection: pulumi.Bool(false),
 * 				EnableSoftDelete:      pulumi.Bool(true),
 * 				InitialAdminObjectIds: pulumi.StringArray{
 * 					pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 				},
 * 				SoftDeleteRetentionInDays: pulumi.Int(90),
 * 				TenantId:                  pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 			},
 * 			ResourceGroupName: pulumi.String("hsm-group"),
 * 			Sku: &keyvault.ManagedHsmSkuArgs{
 * 				Family: pulumi.String(keyvault.ManagedHsmSkuFamilyB),
 * 				Name:   keyvault.ManagedHsmSkuName_Standard_B1,
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Dept":        pulumi.String("hsm"),
 * 				"Environment": pulumi.String("dogfood"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.keyvault.ManagedHsm;
 * import com.pulumi.azurenative.keyvault.ManagedHsmArgs;
 * import com.pulumi.azurenative.keyvault.inputs.ManagedHsmPropertiesArgs;
 * import com.pulumi.azurenative.keyvault.inputs.ManagedHsmSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedHsm = new ManagedHsm("managedHsm", ManagedHsmArgs.builder()
 *             .location("westus")
 *             .name("hsm1")
 *             .properties(ManagedHsmPropertiesArgs.builder()
 *                 .enablePurgeProtection(false)
 *                 .enableSoftDelete(true)
 *                 .initialAdminObjectIds("00000000-0000-0000-0000-000000000000")
 *                 .softDeleteRetentionInDays(90)
 *                 .tenantId("00000000-0000-0000-0000-000000000000")
 *                 .build())
 *             .resourceGroupName("hsm-group")
 *             .sku(ManagedHsmSkuArgs.builder()
 *                 .family("B")
 *                 .name("Standard_B1")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Dept", "hsm"),
 *                 Map.entry("Environment", "dogfood")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:keyvault:ManagedHsm hsm1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs/{name}
 * ```
 */
public class ManagedHsm internal constructor(
    override val javaResource: com.pulumi.azurenative.keyvault.ManagedHsm,
) : KotlinCustomResource(javaResource, ManagedHsmMapper) {
    /**
     * The supported Azure location where the managed HSM Pool should be created.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the managed HSM Pool.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the managed HSM
     */
    public val properties: Output<ManagedHsmPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                managedHsmPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * SKU details
     */
    public val sku: Output<ManagedHsmSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedHsmSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the key vault resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The resource type of the managed HSM Pool.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagedHsmMapper : ResourceMapper<ManagedHsm> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.keyvault.ManagedHsm::class == javaResource::class

    override fun map(javaResource: Resource): ManagedHsm = ManagedHsm(
        javaResource as
            com.pulumi.azurenative.keyvault.ManagedHsm,
    )
}

/**
 * @see [ManagedHsm].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedHsm].
 */
public suspend fun managedHsm(name: String, block: suspend ManagedHsmResourceBuilder.() -> Unit): ManagedHsm {
    val builder = ManagedHsmResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedHsm].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedHsm(name: String): ManagedHsm {
    val builder = ManagedHsmResourceBuilder()
    builder.name(name)
    return builder.build()
}
