@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin

import com.pulumi.azurenative.keyvault.ManagedHsmArgs.builder
import com.pulumi.azurenative.keyvault.kotlin.inputs.ManagedHsmPropertiesArgs
import com.pulumi.azurenative.keyvault.kotlin.inputs.ManagedHsmPropertiesArgsBuilder
import com.pulumi.azurenative.keyvault.kotlin.inputs.ManagedHsmSkuArgs
import com.pulumi.azurenative.keyvault.kotlin.inputs.ManagedHsmSkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource information with extended details.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-06-01-preview.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create a new managed HSM Pool or update an existing managed HSM Pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedHsm = new AzureNative.KeyVault.ManagedHsm("managedHsm", new()
 *     {
 *         Location = "westus",
 *         Name = "hsm1",
 *         Properties = new AzureNative.KeyVault.Inputs.ManagedHsmPropertiesArgs
 *         {
 *             EnablePurgeProtection = false,
 *             EnableSoftDelete = true,
 *             InitialAdminObjectIds = new[]
 *             {
 *                 "00000000-0000-0000-0000-000000000000",
 *             },
 *             SoftDeleteRetentionInDays = 90,
 *             TenantId = "00000000-0000-0000-0000-000000000000",
 *         },
 *         ResourceGroupName = "hsm-group",
 *         Sku = new AzureNative.KeyVault.Inputs.ManagedHsmSkuArgs
 *         {
 *             Family = AzureNative.KeyVault.ManagedHsmSkuFamily.B,
 *             Name = AzureNative.KeyVault.ManagedHsmSkuName.Standard_B1,
 *         },
 *         Tags =
 *         {
 *             { "Dept", "hsm" },
 *             { "Environment", "dogfood" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/keyvault/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := keyvault.NewManagedHsm(ctx, "managedHsm", &keyvault.ManagedHsmArgs{
 * 			Location: pulumi.String("westus"),
 * 			Name:     pulumi.String("hsm1"),
 * 			Properties: &keyvault.ManagedHsmPropertiesArgs{
 * 				EnablePurgeProtection: pulumi.Bool(false),
 * 				EnableSoftDelete:      pulumi.Bool(true),
 * 				InitialAdminObjectIds: pulumi.StringArray{
 * 					pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 				},
 * 				SoftDeleteRetentionInDays: pulumi.Int(90),
 * 				TenantId:                  pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 			},
 * 			ResourceGroupName: pulumi.String("hsm-group"),
 * 			Sku: &keyvault.ManagedHsmSkuArgs{
 * 				Family: pulumi.String(keyvault.ManagedHsmSkuFamilyB),
 * 				Name:   keyvault.ManagedHsmSkuName_Standard_B1,
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Dept":        pulumi.String("hsm"),
 * 				"Environment": pulumi.String("dogfood"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.keyvault.ManagedHsm;
 * import com.pulumi.azurenative.keyvault.ManagedHsmArgs;
 * import com.pulumi.azurenative.keyvault.inputs.ManagedHsmPropertiesArgs;
 * import com.pulumi.azurenative.keyvault.inputs.ManagedHsmSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedHsm = new ManagedHsm("managedHsm", ManagedHsmArgs.builder()
 *             .location("westus")
 *             .name("hsm1")
 *             .properties(ManagedHsmPropertiesArgs.builder()
 *                 .enablePurgeProtection(false)
 *                 .enableSoftDelete(true)
 *                 .initialAdminObjectIds("00000000-0000-0000-0000-000000000000")
 *                 .softDeleteRetentionInDays(90)
 *                 .tenantId("00000000-0000-0000-0000-000000000000")
 *                 .build())
 *             .resourceGroupName("hsm-group")
 *             .sku(ManagedHsmSkuArgs.builder()
 *                 .family("B")
 *                 .name("Standard_B1")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Dept", "hsm"),
 *                 Map.entry("Environment", "dogfood")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:keyvault:ManagedHsm hsm1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs/{name}
 * ```
 * @property location The supported Azure location where the managed HSM Pool should be created.
 * @property name Name of the managed HSM Pool
 * @property properties Properties of the managed HSM
 * @property resourceGroupName Name of the resource group that contains the managed HSM pool.
 * @property sku SKU details
 * @property tags Resource tags
 */
public data class ManagedHsmArgs(
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val properties: Output<ManagedHsmPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<ManagedHsmSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.ManagedHsmArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.ManagedHsmArgs =
        com.pulumi.azurenative.keyvault.ManagedHsmArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ManagedHsmArgs].
 */
@PulumiTagMarker
public class ManagedHsmArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var properties: Output<ManagedHsmPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<ManagedHsmSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The supported Azure location where the managed HSM Pool should be created.
     */
    @JvmName("hrsaqxvrronvdbdv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the managed HSM Pool
     */
    @JvmName("qldmhtlpigrmskyu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Properties of the managed HSM
     */
    @JvmName("ecoodsnkoyuwisrh")
    public suspend fun properties(`value`: Output<ManagedHsmPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the resource group that contains the managed HSM pool.
     */
    @JvmName("gvojtddptuqqqecp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value SKU details
     */
    @JvmName("chaxsallnksrdouw")
    public suspend fun sku(`value`: Output<ManagedHsmSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("rjhlmgcxyaigacpa")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The supported Azure location where the managed HSM Pool should be created.
     */
    @JvmName("qfrfyspppoouasyh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the managed HSM Pool
     */
    @JvmName("hywiqofeyvoiuggm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Properties of the managed HSM
     */
    @JvmName("ntycerrpeqeebaif")
    public suspend fun properties(`value`: ManagedHsmPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the managed HSM
     */
    @JvmName("hcytbakunwrwehef")
    public suspend fun properties(argument: suspend ManagedHsmPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedHsmPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the resource group that contains the managed HSM pool.
     */
    @JvmName("ukemntllkcbdbydy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SKU details
     */
    @JvmName("pneyiyhocxtfesvt")
    public suspend fun sku(`value`: ManagedHsmSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument SKU details
     */
    @JvmName("ytxifyosfkvlajnw")
    public suspend fun sku(argument: suspend ManagedHsmSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedHsmSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("voaoldalueyxmiin")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("jqwlurbslsakwode")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ManagedHsmArgs = ManagedHsmArgs(
        location = location,
        name = name,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
