@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin

import com.pulumi.azurenative.keyvault.VaultArgs.builder
import com.pulumi.azurenative.keyvault.kotlin.inputs.VaultPropertiesArgs
import com.pulumi.azurenative.keyvault.kotlin.inputs.VaultPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource information with extended details.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2019-09-01.
 * Other available API versions: 2018-02-14-preview, 2023-07-01.
 * ## Example Usage
 * ### Create a new vault or update an existing vault
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vault = new AzureNative.KeyVault.Vault("vault", new()
 *     {
 *         Location = "westus",
 *         Properties = new AzureNative.KeyVault.Inputs.VaultPropertiesArgs
 *         {
 *             AccessPolicies = new[]
 *             {
 *                 new AzureNative.KeyVault.Inputs.AccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "00000000-0000-0000-0000-000000000000",
 *                     Permissions = new AzureNative.KeyVault.Inputs.PermissionsArgs
 *                     {
 *                         Certificates = new[]
 *                         {
 *                             AzureNative.KeyVault.CertificatePermissions.@Get,
 *                             AzureNative.KeyVault.CertificatePermissions.List,
 *                             AzureNative.KeyVault.CertificatePermissions.Delete,
 *                             AzureNative.KeyVault.CertificatePermissions.Create,
 *                             AzureNative.KeyVault.CertificatePermissions.Import,
 *                             AzureNative.KeyVault.CertificatePermissions.Update,
 *                             AzureNative.KeyVault.CertificatePermissions.Managecontacts,
 *                             AzureNative.KeyVault.CertificatePermissions.Getissuers,
 *                             AzureNative.KeyVault.CertificatePermissions.Listissuers,
 *                             AzureNative.KeyVault.CertificatePermissions.Setissuers,
 *                             AzureNative.KeyVault.CertificatePermissions.Deleteissuers,
 *                             AzureNative.KeyVault.CertificatePermissions.Manageissuers,
 *                             AzureNative.KeyVault.CertificatePermissions.Recover,
 *                             AzureNative.KeyVault.CertificatePermissions.Purge,
 *                         },
 *                         Keys = new[]
 *                         {
 *                             AzureNative.KeyVault.KeyPermissions.Encrypt,
 *                             AzureNative.KeyVault.KeyPermissions.Decrypt,
 *                             AzureNative.KeyVault.KeyPermissions.WrapKey,
 *                             AzureNative.KeyVault.KeyPermissions.UnwrapKey,
 *                             AzureNative.KeyVault.KeyPermissions.Sign,
 *                             AzureNative.KeyVault.KeyPermissions.Verify,
 *                             AzureNative.KeyVault.KeyPermissions.@Get,
 *                             AzureNative.KeyVault.KeyPermissions.List,
 *                             AzureNative.KeyVault.KeyPermissions.Create,
 *                             AzureNative.KeyVault.KeyPermissions.Update,
 *                             AzureNative.KeyVault.KeyPermissions.Import,
 *                             AzureNative.KeyVault.KeyPermissions.Delete,
 *                             AzureNative.KeyVault.KeyPermissions.Backup,
 *                             AzureNative.KeyVault.KeyPermissions.Restore,
 *                             AzureNative.KeyVault.KeyPermissions.Recover,
 *                             AzureNative.KeyVault.KeyPermissions.Purge,
 *                         },
 *                         Secrets = new[]
 *                         {
 *                             AzureNative.KeyVault.SecretPermissions.@Get,
 *                             AzureNative.KeyVault.SecretPermissions.List,
 *                             AzureNative.KeyVault.SecretPermissions.@Set,
 *                             AzureNative.KeyVault.SecretPermissions.Delete,
 *                             AzureNative.KeyVault.SecretPermissions.Backup,
 *                             AzureNative.KeyVault.SecretPermissions.Restore,
 *                             AzureNative.KeyVault.SecretPermissions.Recover,
 *                             AzureNative.KeyVault.SecretPermissions.Purge,
 *                         },
 *                     },
 *                     TenantId = "00000000-0000-0000-0000-000000000000",
 *                 },
 *             },
 *             EnabledForDeployment = true,
 *             EnabledForDiskEncryption = true,
 *             EnabledForTemplateDeployment = true,
 *             PublicNetworkAccess = "Enabled",
 *             Sku = new AzureNative.KeyVault.Inputs.SkuArgs
 *             {
 *                 Family = AzureNative.KeyVault.SkuFamily.A,
 *                 Name = AzureNative.KeyVault.SkuName.Standard,
 *             },
 *             TenantId = "00000000-0000-0000-0000-000000000000",
 *         },
 *         ResourceGroupName = "sample-resource-group",
 *         VaultName = "sample-vault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/keyvault/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := keyvault.NewVault(ctx, "vault", &keyvault.VaultArgs{
 * 			Location: pulumi.String("westus"),
 * 			Properties: &keyvault.VaultPropertiesArgs{
 * 				AccessPolicies: keyvault.AccessPolicyEntryArray{
 * 					&keyvault.AccessPolicyEntryArgs{
 * 						ObjectId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 						Permissions: &keyvault.PermissionsArgs{
 * 							Certificates: pulumi.StringArray{
 * 								pulumi.String(keyvault.CertificatePermissionsGet),
 * 								pulumi.String(keyvault.CertificatePermissionsList),
 * 								pulumi.String(keyvault.CertificatePermissionsDelete),
 * 								pulumi.String(keyvault.CertificatePermissionsCreate),
 * 								pulumi.String(keyvault.CertificatePermissionsImport),
 * 								pulumi.String(keyvault.CertificatePermissionsUpdate),
 * 								pulumi.String(keyvault.CertificatePermissionsManagecontacts),
 * 								pulumi.String(keyvault.CertificatePermissionsGetissuers),
 * 								pulumi.String(keyvault.CertificatePermissionsListissuers),
 * 								pulumi.String(keyvault.CertificatePermissionsSetissuers),
 * 								pulumi.String(keyvault.CertificatePermissionsDeleteissuers),
 * 								pulumi.String(keyvault.CertificatePermissionsManageissuers),
 * 								pulumi.String(keyvault.CertificatePermissionsRecover),
 * 								pulumi.String(keyvault.CertificatePermissionsPurge),
 * 							},
 * 							Keys: pulumi.StringArray{
 * 								pulumi.String(keyvault.KeyPermissionsEncrypt),
 * 								pulumi.String(keyvault.KeyPermissionsDecrypt),
 * 								pulumi.String(keyvault.KeyPermissionsWrapKey),
 * 								pulumi.String(keyvault.KeyPermissionsUnwrapKey),
 * 								pulumi.String(keyvault.KeyPermissionsSign),
 * 								pulumi.String(keyvault.KeyPermissionsVerify),
 * 								pulumi.String(keyvault.KeyPermissionsGet),
 * 								pulumi.String(keyvault.KeyPermissionsList),
 * 								pulumi.String(keyvault.KeyPermissionsCreate),
 * 								pulumi.String(keyvault.KeyPermissionsUpdate),
 * 								pulumi.String(keyvault.KeyPermissionsImport),
 * 								pulumi.String(keyvault.KeyPermissionsDelete),
 * 								pulumi.String(keyvault.KeyPermissionsBackup),
 * 								pulumi.String(keyvault.KeyPermissionsRestore),
 * 								pulumi.String(keyvault.KeyPermissionsRecover),
 * 								pulumi.String(keyvault.KeyPermissionsPurge),
 * 							},
 * 							Secrets: pulumi.StringArray{
 * 								pulumi.String(keyvault.SecretPermissionsGet),
 * 								pulumi.String(keyvault.SecretPermissionsList),
 * 								pulumi.String(keyvault.SecretPermissionsSet),
 * 								pulumi.String(keyvault.SecretPermissionsDelete),
 * 								pulumi.String(keyvault.SecretPermissionsBackup),
 * 								pulumi.String(keyvault.SecretPermissionsRestore),
 * 								pulumi.String(keyvault.SecretPermissionsRecover),
 * 								pulumi.String(keyvault.SecretPermissionsPurge),
 * 							},
 * 						},
 * 						TenantId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 					},
 * 				},
 * 				EnabledForDeployment:         pulumi.Bool(true),
 * 				EnabledForDiskEncryption:     pulumi.Bool(true),
 * 				EnabledForTemplateDeployment: pulumi.Bool(true),
 * 				PublicNetworkAccess:          pulumi.String("Enabled"),
 * 				Sku: &keyvault.SkuArgs{
 * 					Family: pulumi.String(keyvault.SkuFamilyA),
 * 					Name:   keyvault.SkuNameStandard,
 * 				},
 * 				TenantId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 			},
 * 			ResourceGroupName: pulumi.String("sample-resource-group"),
 * 			VaultName:         pulumi.String("sample-vault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.keyvault.Vault;
 * import com.pulumi.azurenative.keyvault.VaultArgs;
 * import com.pulumi.azurenative.keyvault.inputs.VaultPropertiesArgs;
 * import com.pulumi.azurenative.keyvault.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vault = new Vault("vault", VaultArgs.builder()
 *             .location("westus")
 *             .properties(VaultPropertiesArgs.builder()
 *                 .accessPolicies(AccessPolicyEntryArgs.builder()
 *                     .objectId("00000000-0000-0000-0000-000000000000")
 *                     .permissions(PermissionsArgs.builder()
 *                         .certificates(
 *                             "get",
 *                             "list",
 *                             "delete",
 *                             "create",
 *                             "import",
 *                             "update",
 *                             "managecontacts",
 *                             "getissuers",
 *                             "listissuers",
 *                             "setissuers",
 *                             "deleteissuers",
 *                             "manageissuers",
 *                             "recover",
 *                             "purge")
 *                         .keys(
 *                             "encrypt",
 *                             "decrypt",
 *                             "wrapKey",
 *                             "unwrapKey",
 *                             "sign",
 *                             "verify",
 *                             "get",
 *                             "list",
 *                             "create",
 *                             "update",
 *                             "import",
 *                             "delete",
 *                             "backup",
 *                             "restore",
 *                             "recover",
 *                             "purge")
 *                         .secrets(
 *                             "get",
 *                             "list",
 *                             "set",
 *                             "delete",
 *                             "backup",
 *                             "restore",
 *                             "recover",
 *                             "purge")
 *                         .build())
 *                     .tenantId("00000000-0000-0000-0000-000000000000")
 *                     .build())
 *                 .enabledForDeployment(true)
 *                 .enabledForDiskEncryption(true)
 *                 .enabledForTemplateDeployment(true)
 *                 .publicNetworkAccess("Enabled")
 *                 .sku(SkuArgs.builder()
 *                     .family("A")
 *                     .name("standard")
 *                     .build())
 *                 .tenantId("00000000-0000-0000-0000-000000000000")
 *                 .build())
 *             .resourceGroupName("sample-resource-group")
 *             .vaultName("sample-vault")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a vault with network acls
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vault = new AzureNative.KeyVault.Vault("vault", new()
 *     {
 *         Location = "westus",
 *         Properties = new AzureNative.KeyVault.Inputs.VaultPropertiesArgs
 *         {
 *             EnabledForDeployment = true,
 *             EnabledForDiskEncryption = true,
 *             EnabledForTemplateDeployment = true,
 *             NetworkAcls = new AzureNative.KeyVault.Inputs.NetworkRuleSetArgs
 *             {
 *                 Bypass = AzureNative.KeyVault.NetworkRuleBypassOptions.AzureServices,
 *                 DefaultAction = AzureNative.KeyVault.NetworkRuleAction.Deny,
 *                 IpRules = new[]
 *                 {
 *                     new AzureNative.KeyVault.Inputs.IPRuleArgs
 *                     {
 *                         Value = "124.56.78.91",
 *                     },
 *                     new AzureNative.KeyVault.Inputs.IPRuleArgs
 *                     {
 *                         Value = "'10.91.4.0/24'",
 *                     },
 *                 },
 *                 VirtualNetworkRules = new[]
 *                 {
 *                     new AzureNative.KeyVault.Inputs.VirtualNetworkRuleArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1",
 *                     },
 *                 },
 *             },
 *             Sku = new AzureNative.KeyVault.Inputs.SkuArgs
 *             {
 *                 Family = AzureNative.KeyVault.SkuFamily.A,
 *                 Name = AzureNative.KeyVault.SkuName.Standard,
 *             },
 *             TenantId = "00000000-0000-0000-0000-000000000000",
 *         },
 *         ResourceGroupName = "sample-resource-group",
 *         VaultName = "sample-vault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/keyvault/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := keyvault.NewVault(ctx, "vault", &keyvault.VaultArgs{
 * 			Location: pulumi.String("westus"),
 * 			Properties: &keyvault.VaultPropertiesArgs{
 * 				EnabledForDeployment:         pulumi.Bool(true),
 * 				EnabledForDiskEncryption:     pulumi.Bool(true),
 * 				EnabledForTemplateDeployment: pulumi.Bool(true),
 * 				NetworkAcls: &keyvault.NetworkRuleSetArgs{
 * 					Bypass:        pulumi.String(keyvault.NetworkRuleBypassOptionsAzureServices),
 * 					DefaultAction: pulumi.String(keyvault.NetworkRuleActionDeny),
 * 					IpRules: keyvault.IPRuleArray{
 * 						&keyvault.IPRuleArgs{
 * 							Value: pulumi.String("124.56.78.91"),
 * 						},
 * 						&keyvault.IPRuleArgs{
 * 							Value: pulumi.String("'10.91.4.0/24'"),
 * 						},
 * 					},
 * 					VirtualNetworkRules: keyvault.VirtualNetworkRuleArray{
 * 						&keyvault.VirtualNetworkRuleArgs{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1"),
 * 						},
 * 					},
 * 				},
 * 				Sku: &keyvault.SkuArgs{
 * 					Family: pulumi.String(keyvault.SkuFamilyA),
 * 					Name:   keyvault.SkuNameStandard,
 * 				},
 * 				TenantId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 			},
 * 			ResourceGroupName: pulumi.String("sample-resource-group"),
 * 			VaultName:         pulumi.String("sample-vault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.keyvault.Vault;
 * import com.pulumi.azurenative.keyvault.VaultArgs;
 * import com.pulumi.azurenative.keyvault.inputs.VaultPropertiesArgs;
 * import com.pulumi.azurenative.keyvault.inputs.NetworkRuleSetArgs;
 * import com.pulumi.azurenative.keyvault.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vault = new Vault("vault", VaultArgs.builder()
 *             .location("westus")
 *             .properties(VaultPropertiesArgs.builder()
 *                 .enabledForDeployment(true)
 *                 .enabledForDiskEncryption(true)
 *                 .enabledForTemplateDeployment(true)
 *                 .networkAcls(NetworkRuleSetArgs.builder()
 *                     .bypass("AzureServices")
 *                     .defaultAction("Deny")
 *                     .ipRules(
 *                         IPRuleArgs.builder()
 *                             .value("124.56.78.91")
 *                             .build(),
 *                         IPRuleArgs.builder()
 *                             .value("'10.91.4.0/24'")
 *                             .build())
 *                     .virtualNetworkRules(VirtualNetworkRuleArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1")
 *                         .build())
 *                     .build())
 *                 .sku(SkuArgs.builder()
 *                     .family("A")
 *                     .name("standard")
 *                     .build())
 *                 .tenantId("00000000-0000-0000-0000-000000000000")
 *                 .build())
 *             .resourceGroupName("sample-resource-group")
 *             .vaultName("sample-vault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:keyvault:Vault sample-vault /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}
 * ```
 * @property location The supported Azure location where the key vault should be created.
 * @property properties Properties of the vault
 * @property resourceGroupName The name of the Resource Group to which the server belongs.
 * @property tags The tags that will be assigned to the key vault.
 * @property vaultName Name of the vault
 */
public data class VaultArgs(
    public val location: Output<String>? = null,
    public val properties: Output<VaultPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vaultName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.VaultArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.VaultArgs =
        com.pulumi.azurenative.keyvault.VaultArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VaultArgs].
 */
@PulumiTagMarker
public class VaultArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var properties: Output<VaultPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vaultName: Output<String>? = null

    /**
     * @param value The supported Azure location where the key vault should be created.
     */
    @JvmName("mavrxpajtapswiaj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties of the vault
     */
    @JvmName("gilnnpxjyffrxaxp")
    public suspend fun properties(`value`: Output<VaultPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the Resource Group to which the server belongs.
     */
    @JvmName("abwlgswhdilqhqgh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tags that will be assigned to the key vault.
     */
    @JvmName("mkebmsbdcowulicl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the vault
     */
    @JvmName("drntmkkjcxjofstu")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value The supported Azure location where the key vault should be created.
     */
    @JvmName("tbsdllsigruhmjvm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties of the vault
     */
    @JvmName("gxbhykuxsbmoueit")
    public suspend fun properties(`value`: VaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the vault
     */
    @JvmName("qolubedjaybpfcgi")
    public suspend fun properties(argument: suspend VaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the Resource Group to which the server belongs.
     */
    @JvmName("gwqyexkskxstrhae")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tags that will be assigned to the key vault.
     */
    @JvmName("fnesfqdonirnrtlq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags that will be assigned to the key vault.
     */
    @JvmName("wykxcfwiolnotbck")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of the vault
     */
    @JvmName("dxwcwokvnclptaxu")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    internal fun build(): VaultArgs = VaultArgs(
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vaultName = vaultName,
    )
}
