@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not specified the default is 'AzureServices'.
 */
public enum class NetworkRuleBypassOptions(
    public val javaValue: com.pulumi.azurenative.keyvault.enums.NetworkRuleBypassOptions,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.enums.NetworkRuleBypassOptions> {
    AzureServices(com.pulumi.azurenative.keyvault.enums.NetworkRuleBypassOptions.AzureServices),
    None(com.pulumi.azurenative.keyvault.enums.NetworkRuleBypassOptions.None),
    ;

    override fun toJava(): com.pulumi.azurenative.keyvault.enums.NetworkRuleBypassOptions = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.enums.NetworkRuleBypassOptions): NetworkRuleBypassOptions =
            NetworkRuleBypassOptions.values().first { it.javaValue == javaType }
    }
}
