@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.ActionArgs.builder
import com.pulumi.azurenative.keyvault.kotlin.enums.KeyRotationPolicyActionType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type The type of the action. The value should be compared case-insensitively.
 */
public data class ActionArgs(
    public val type: Output<KeyRotationPolicyActionType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.ActionArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.ActionArgs =
        com.pulumi.azurenative.keyvault.inputs.ActionArgs.builder()
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ActionArgs].
 */
@PulumiTagMarker
public class ActionArgsBuilder internal constructor() {
    private var type: Output<KeyRotationPolicyActionType>? = null

    /**
     * @param value The type of the action. The value should be compared case-insensitively.
     */
    @JvmName("mjaptsfmoegwrxuc")
    public suspend fun type(`value`: Output<KeyRotationPolicyActionType>) {
        this.type = value
    }

    /**
     * @param value The type of the action. The value should be compared case-insensitively.
     */
    @JvmName("ahtmevjrlbwnenhu")
    public suspend fun type(`value`: KeyRotationPolicyActionType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ActionArgs = ActionArgs(
        type = type,
    )
}
