@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.GetSecretPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the Resource Group to which the vault belongs.
 * @property secretName The name of the secret.
 * @property vaultName The name of the vault.
 */
public data class GetSecretPlainArgs(
    public val resourceGroupName: String,
    public val secretName: String,
    public val vaultName: String,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.GetSecretPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.GetSecretPlainArgs =
        com.pulumi.azurenative.keyvault.inputs.GetSecretPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .secretName(secretName.let({ args0 -> args0 }))
            .vaultName(vaultName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecretPlainArgs].
 */
@PulumiTagMarker
public class GetSecretPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var secretName: String? = null

    private var vaultName: String? = null

    /**
     * @param value The name of the Resource Group to which the vault belongs.
     */
    @JvmName("yjsvjhtcjnogprnl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the secret.
     */
    @JvmName("pfitntrhgjnsklrr")
    public suspend fun secretName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.secretName = mapped
    }

    /**
     * @param value The name of the vault.
     */
    @JvmName("vmkahhjgcmjcwhox")
    public suspend fun vaultName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vaultName = mapped
    }

    internal fun build(): GetSecretPlainArgs = GetSecretPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        secretName = secretName ?: throw PulumiNullFieldException("secretName"),
        vaultName = vaultName ?: throw PulumiNullFieldException("vaultName"),
    )
}
