@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.RotationPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property attributes The attributes of key rotation policy.
 * @property lifetimeActions The lifetimeActions for key rotation action.
 */
public data class RotationPolicyArgs(
    public val attributes: Output<KeyRotationPolicyAttributesArgs>? = null,
    public val lifetimeActions: Output<List<LifetimeActionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.RotationPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.RotationPolicyArgs =
        com.pulumi.azurenative.keyvault.inputs.RotationPolicyArgs.builder()
            .attributes(attributes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .lifetimeActions(
                lifetimeActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RotationPolicyArgs].
 */
@PulumiTagMarker
public class RotationPolicyArgsBuilder internal constructor() {
    private var attributes: Output<KeyRotationPolicyAttributesArgs>? = null

    private var lifetimeActions: Output<List<LifetimeActionArgs>>? = null

    /**
     * @param value The attributes of key rotation policy.
     */
    @JvmName("lmhdahqyrjsxhqow")
    public suspend fun attributes(`value`: Output<KeyRotationPolicyAttributesArgs>) {
        this.attributes = value
    }

    /**
     * @param value The lifetimeActions for key rotation action.
     */
    @JvmName("nireufaecprxlyxt")
    public suspend fun lifetimeActions(`value`: Output<List<LifetimeActionArgs>>) {
        this.lifetimeActions = value
    }

    @JvmName("rwjrohwofeespmbo")
    public suspend fun lifetimeActions(vararg values: Output<LifetimeActionArgs>) {
        this.lifetimeActions = Output.all(values.asList())
    }

    /**
     * @param values The lifetimeActions for key rotation action.
     */
    @JvmName("pltbwxqyfjywrjtt")
    public suspend fun lifetimeActions(values: List<Output<LifetimeActionArgs>>) {
        this.lifetimeActions = Output.all(values)
    }

    /**
     * @param value The attributes of key rotation policy.
     */
    @JvmName("xymurirxsxtaadcc")
    public suspend fun attributes(`value`: KeyRotationPolicyAttributesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param argument The attributes of key rotation policy.
     */
    @JvmName("psgdlhbaoaoxbxpg")
    public suspend fun attributes(argument: suspend KeyRotationPolicyAttributesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyRotationPolicyAttributesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param value The lifetimeActions for key rotation action.
     */
    @JvmName("dsatmtlsiqftcktv")
    public suspend fun lifetimeActions(`value`: List<LifetimeActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifetimeActions = mapped
    }

    /**
     * @param argument The lifetimeActions for key rotation action.
     */
    @JvmName("qjvbrhrtnxnqlefj")
    public suspend fun lifetimeActions(argument: List<suspend LifetimeActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LifetimeActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lifetimeActions = mapped
    }

    /**
     * @param argument The lifetimeActions for key rotation action.
     */
    @JvmName("naywkbnxmddavxsj")
    public suspend fun lifetimeActions(vararg argument: suspend LifetimeActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LifetimeActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lifetimeActions = mapped
    }

    /**
     * @param argument The lifetimeActions for key rotation action.
     */
    @JvmName("krlhwqxuvydhefwx")
    public suspend fun lifetimeActions(argument: suspend LifetimeActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LifetimeActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.lifetimeActions = mapped
    }

    /**
     * @param values The lifetimeActions for key rotation action.
     */
    @JvmName("qwjmyoguppoykjkt")
    public suspend fun lifetimeActions(vararg values: LifetimeActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifetimeActions = mapped
    }

    internal fun build(): RotationPolicyArgs = RotationPolicyArgs(
        attributes = attributes,
        lifetimeActions = lifetimeActions,
    )
}
