@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Resource information with extended details.
 * @property id Fully qualified identifier of the key vault resource.
 * @property location Azure location of the key vault resource.
 * @property name Name of the key vault resource.
 * @property properties Properties of the vault
 * @property systemData System metadata for the key vault.
 * @property tags Tags assigned to the key vault resource.
 * @property type Resource type of the key vault resource.
 */
public data class GetVaultResult(
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: VaultPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.GetVaultResult): GetVaultResult = GetVaultResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.keyvault.kotlin.outputs.VaultPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.keyvault.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
