@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The object attributes managed by the Azure Key Vault service.
 * @property created Creation time in seconds since 1970-01-01T00:00:00Z.
 * @property enabled Determines whether or not the object is enabled.
 * @property expires Expiry date in seconds since 1970-01-01T00:00:00Z.
 * @property exportable Indicates if the private key can be exported.
 * @property notBefore Not before date in seconds since 1970-01-01T00:00:00Z.
 * @property recoveryLevel The deletion recovery level currently in effect for the object. If it contains 'Purgeable', then the object can be permanently deleted by a privileged user; otherwise, only the system can purge the object at the end of the retention interval.
 * @property updated Last updated time in seconds since 1970-01-01T00:00:00Z.
 */
public data class KeyAttributesResponse(
    public val created: Double,
    public val enabled: Boolean? = null,
    public val expires: Double? = null,
    public val exportable: Boolean? = null,
    public val notBefore: Double? = null,
    public val recoveryLevel: String,
    public val updated: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.KeyAttributesResponse): KeyAttributesResponse = KeyAttributesResponse(
            created = javaType.created(),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            expires = javaType.expires().map({ args0 -> args0 }).orElse(null),
            exportable = javaType.exportable().map({ args0 -> args0 }).orElse(null),
            notBefore = javaType.notBefore().map({ args0 -> args0 }).orElse(null),
            recoveryLevel = javaType.recoveryLevel(),
            updated = javaType.updated(),
        )
    }
}
