@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An object that represents the approval state of the private link connection.
 * @property actionsRequired A message indicating if changes on the service provider require any updates on the consumer.
 * @property description The reason for approval or rejection.
 * @property status Indicates whether the connection has been approved, rejected or removed by the key vault owner.
 */
public data class MHSMPrivateLinkServiceConnectionStateResponse(
    public val actionsRequired: String? = null,
    public val description: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.MHSMPrivateLinkServiceConnectionStateResponse): MHSMPrivateLinkServiceConnectionStateResponse =
            MHSMPrivateLinkServiceConnectionStateResponse(
                actionsRequired = javaType.actionsRequired().map({ args0 -> args0 }).orElse(null),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
            )
    }
}
