@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The security domain properties of the managed hsm.
 * @property activationStatus Activation Status
 * @property activationStatusMessage Activation Status Message.
 */
public data class ManagedHSMSecurityDomainPropertiesResponse(
    public val activationStatus: String,
    public val activationStatusMessage: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.ManagedHSMSecurityDomainPropertiesResponse): ManagedHSMSecurityDomainPropertiesResponse = ManagedHSMSecurityDomainPropertiesResponse(
            activationStatus = javaType.activationStatus(),
            activationStatusMessage = javaType.activationStatusMessage(),
        )
    }
}
