@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of the managed HSM Pool
 * @property enablePurgeProtection Property specifying whether protection against purge is enabled for this managed HSM pool. Setting this property to true activates protection against purge for this managed HSM pool and its content - only the Managed HSM service may initiate a hard, irrecoverable deletion. Enabling this functionality is irreversible.
 * @property enableSoftDelete Property to specify whether the 'soft delete' functionality is enabled for this managed HSM pool. Soft delete is enabled by default for all managed HSMs and is immutable.
 * @property hsmUri The URI of the managed hsm pool for performing operations on keys.
 * @property initialAdminObjectIds Array of initial administrators object ids for this managed hsm pool.
 * @property networkAcls Rules governing the accessibility of the key vault from specific network locations.
 * @property privateEndpointConnections List of private endpoint connections associated with the managed hsm pool.
 * @property provisioningState Provisioning state.
 * @property publicNetworkAccess Control permission to the managed HSM from public networks.
 * @property regions List of all regions associated with the managed hsm pool.
 * @property scheduledPurgeDate The scheduled purge date in UTC.
 * @property securityDomainProperties Managed HSM security domain properties.
 * @property softDeleteRetentionInDays Soft deleted data retention days. When you delete an HSM or a key, it will remain recoverable for the configured retention period or for a default period of 90 days. It accepts values between 7 and 90.
 * @property statusMessage Resource Status Message.
 * @property tenantId The Azure Active Directory tenant ID that should be used for authenticating requests to the managed HSM pool.
 */
public data class ManagedHsmPropertiesResponse(
    public val enablePurgeProtection: Boolean? = null,
    public val enableSoftDelete: Boolean? = null,
    public val hsmUri: String,
    public val initialAdminObjectIds: List<String>? = null,
    public val networkAcls: MHSMNetworkRuleSetResponse? = null,
    public val privateEndpointConnections: List<MHSMPrivateEndpointConnectionItemResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val regions: List<MHSMGeoReplicatedRegionResponse>? = null,
    public val scheduledPurgeDate: String,
    public val securityDomainProperties: ManagedHSMSecurityDomainPropertiesResponse,
    public val softDeleteRetentionInDays: Int? = null,
    public val statusMessage: String,
    public val tenantId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.ManagedHsmPropertiesResponse): ManagedHsmPropertiesResponse = ManagedHsmPropertiesResponse(
            enablePurgeProtection = javaType.enablePurgeProtection().map({ args0 -> args0 }).orElse(null),
            enableSoftDelete = javaType.enableSoftDelete().map({ args0 -> args0 }).orElse(null),
            hsmUri = javaType.hsmUri(),
            initialAdminObjectIds = javaType.initialAdminObjectIds().map({ args0 -> args0 }),
            networkAcls = javaType.networkAcls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.keyvault.kotlin.outputs.MHSMNetworkRuleSetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.keyvault.kotlin.outputs.MHSMPrivateEndpointConnectionItemResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            regions = javaType.regions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.keyvault.kotlin.outputs.MHSMGeoReplicatedRegionResponse.Companion.toKotlin(args0)
                })
            }),
            scheduledPurgeDate = javaType.scheduledPurgeDate(),
            securityDomainProperties = javaType.securityDomainProperties().let({ args0 ->
                com.pulumi.azurenative.keyvault.kotlin.outputs.ManagedHSMSecurityDomainPropertiesResponse.Companion.toKotlin(args0)
            }),
            softDeleteRetentionInDays = javaType.softDeleteRetentionInDays().map({ args0 ->
                args0
            }).orElse(null),
            statusMessage = javaType.statusMessage(),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
