@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A set of rules governing the network accessibility of a vault.
 * @property bypass Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not specified the default is 'AzureServices'.
 * @property defaultAction The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
 * @property ipRules The list of IP address rules.
 * @property virtualNetworkRules The list of virtual network rules.
 */
public data class NetworkRuleSetResponse(
    public val bypass: String? = null,
    public val defaultAction: String? = null,
    public val ipRules: List<IPRuleResponse>? = null,
    public val virtualNetworkRules: List<VirtualNetworkRuleResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.NetworkRuleSetResponse): NetworkRuleSetResponse = NetworkRuleSetResponse(
            bypass = javaType.bypass().map({ args0 -> args0 }).orElse(null),
            defaultAction = javaType.defaultAction().map({ args0 -> args0 }).orElse(null),
            ipRules = javaType.ipRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.keyvault.kotlin.outputs.IPRuleResponse.Companion.toKotlin(args0)
                })
            }),
            virtualNetworkRules = javaType.virtualNetworkRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.keyvault.kotlin.outputs.VirtualNetworkRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
