@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Permissions the identity has for keys, secrets, certificates and storage.
 * @property certificates Permissions to certificates
 * @property keys Permissions to keys
 * @property secrets Permissions to secrets
 * @property storage Permissions to storage accounts
 */
public data class PermissionsResponse(
    public val certificates: List<String>? = null,
    public val keys: List<String>? = null,
    public val secrets: List<String>? = null,
    public val storage: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.PermissionsResponse): PermissionsResponse = PermissionsResponse(
            certificates = javaType.certificates().map({ args0 -> args0 }),
            keys = javaType.keys().map({ args0 -> args0 }),
            secrets = javaType.secrets().map({ args0 -> args0 }),
            storage = javaType.storage().map({ args0 -> args0 }),
        )
    }
}
