@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * SKU details
 * @property family SKU family name
 * @property name SKU name to specify whether the key vault is a standard vault or a premium vault.
 */
public data class SkuResponse(
    public val family: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.SkuResponse): SkuResponse = SkuResponse(
            family = javaType.family(),
            name = javaType.name(),
        )
    }
}
