@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetes.kotlin

import com.pulumi.azurenative.kubernetes.ConnectedClusterArgs.builder
import com.pulumi.azurenative.kubernetes.kotlin.enums.PrivateLinkState
import com.pulumi.azurenative.kubernetes.kotlin.enums.ProvisioningState
import com.pulumi.azurenative.kubernetes.kotlin.inputs.ConnectedClusterIdentityArgs
import com.pulumi.azurenative.kubernetes.kotlin.inputs.ConnectedClusterIdentityArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents a connected cluster.
 * Azure REST API version: 2022-05-01-preview. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2020-01-01-preview, 2022-10-01-preview, 2023-11-01-preview, 2024-01-01, 2024-02-01-preview.
 * ## Example Usage
 * ### CreateClusterExample
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectedCluster = new AzureNative.Kubernetes.ConnectedCluster("connectedCluster", new()
 *     {
 *         AgentPublicKeyCertificate = "MIICYzCCAcygAwIBAgIBADANBgkqhkiG9w0BAQUFADAuMQswCQYDVQQGEwJVUzEMMAoGA1UEChMDSUJNMREwDwYDVQQLEwhMb2NhbCBDQTAeFw05OTEyMjIwNTAwMDBaFw0wMDEyMjMwNDU5NTlaMC4xCzAJBgNVBAYTAlVTMQwwCgYDVQQKEwNJQk0xETAPBgNVBAsTCExvY2FsIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQD2bZEo7xGaX2/0GHkrNFZvlxBou9v1Jmt/PDiTMPve8r9FeJAQ0QdvFST/0JPQYD20rH0bimdDLgNdNynmyRoS2S/IInfpmf69iyc2G0TPyRvmHIiOZbdCd+YBHQi1adkj17NDcWj6S14tVurFX73zx0sNoMS79q3tuXKrDsxeuwIDAQABo4GQMIGNMEsGCVUdDwGG+EIBDQQ+EzxHZW5lcmF0ZWQgYnkgdGhlIFNlY3VyZVdheSBTZWN1cml0eSBTZXJ2ZXIgZm9yIE9TLzM5MCAoUkFDRikwDgYDVR0PAQH/BAQDAgAGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFJ3+ocRyCTJw067dLSwr/nalx6YMMA0GCSqGSIb3DQEBBQUAA4GBAMaQzt+zaj1GU77yzlr8iiMBXgdQrwsZZWJo5exnAucJAEYQZmOfyLiM D6oYq+ZnfvM0n8G/Y79q8nhwvuxpYOnRSAXFp6xSkrIOeZtJMY1h00LKp/JX3Ng1svZ2agE126JHsQ0bhzN5TKsYfbwfTwfjdWAGy6Vf1nYi/rO+ryMO",
 *         ClusterName = "testCluster",
 *         Identity = new AzureNative.Kubernetes.Inputs.ConnectedClusterIdentityArgs
 *         {
 *             Type = AzureNative.Kubernetes.ResourceIdentityType.SystemAssigned,
 *         },
 *         Location = "East US",
 *         ResourceGroupName = "k8sc-rg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetes/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetes.NewConnectedCluster(ctx, "connectedCluster", &kubernetes.ConnectedClusterArgs{
 * 			AgentPublicKeyCertificate: pulumi.String("MIICYzCCAcygAwIBAgIBADANBgkqhkiG9w0BAQUFADAuMQswCQYDVQQGEwJVUzEMMAoGA1UEChMDSUJNMREwDwYDVQQLEwhMb2NhbCBDQTAeFw05OTEyMjIwNTAwMDBaFw0wMDEyMjMwNDU5NTlaMC4xCzAJBgNVBAYTAlVTMQwwCgYDVQQKEwNJQk0xETAPBgNVBAsTCExvY2FsIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQD2bZEo7xGaX2/0GHkrNFZvlxBou9v1Jmt/PDiTMPve8r9FeJAQ0QdvFST/0JPQYD20rH0bimdDLgNdNynmyRoS2S/IInfpmf69iyc2G0TPyRvmHIiOZbdCd+YBHQi1adkj17NDcWj6S14tVurFX73zx0sNoMS79q3tuXKrDsxeuwIDAQABo4GQMIGNMEsGCVUdDwGG+EIBDQQ+EzxHZW5lcmF0ZWQgYnkgdGhlIFNlY3VyZVdheSBTZWN1cml0eSBTZXJ2ZXIgZm9yIE9TLzM5MCAoUkFDRikwDgYDVR0PAQH/BAQDAgAGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFJ3+ocRyCTJw067dLSwr/nalx6YMMA0GCSqGSIb3DQEBBQUAA4GBAMaQzt+zaj1GU77yzlr8iiMBXgdQrwsZZWJo5exnAucJAEYQZmOfyLiM D6oYq+ZnfvM0n8G/Y79q8nhwvuxpYOnRSAXFp6xSkrIOeZtJMY1h00LKp/JX3Ng1svZ2agE126JHsQ0bhzN5TKsYfbwfTwfjdWAGy6Vf1nYi/rO+ryMO"),
 * 			ClusterName:               pulumi.String("testCluster"),
 * 			Identity: &kubernetes.ConnectedClusterIdentityArgs{
 * 				Type: kubernetes.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			Location:          pulumi.String("East US"),
 * 			ResourceGroupName: pulumi.String("k8sc-rg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetes.ConnectedCluster;
 * import com.pulumi.azurenative.kubernetes.ConnectedClusterArgs;
 * import com.pulumi.azurenative.kubernetes.inputs.ConnectedClusterIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectedCluster = new ConnectedCluster("connectedCluster", ConnectedClusterArgs.builder()
 *             .agentPublicKeyCertificate("MIICYzCCAcygAwIBAgIBADANBgkqhkiG9w0BAQUFADAuMQswCQYDVQQGEwJVUzEMMAoGA1UEChMDSUJNMREwDwYDVQQLEwhMb2NhbCBDQTAeFw05OTEyMjIwNTAwMDBaFw0wMDEyMjMwNDU5NTlaMC4xCzAJBgNVBAYTAlVTMQwwCgYDVQQKEwNJQk0xETAPBgNVBAsTCExvY2FsIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQD2bZEo7xGaX2/0GHkrNFZvlxBou9v1Jmt/PDiTMPve8r9FeJAQ0QdvFST/0JPQYD20rH0bimdDLgNdNynmyRoS2S/IInfpmf69iyc2G0TPyRvmHIiOZbdCd+YBHQi1adkj17NDcWj6S14tVurFX73zx0sNoMS79q3tuXKrDsxeuwIDAQABo4GQMIGNMEsGCVUdDwGG+EIBDQQ+EzxHZW5lcmF0ZWQgYnkgdGhlIFNlY3VyZVdheSBTZWN1cml0eSBTZXJ2ZXIgZm9yIE9TLzM5MCAoUkFDRikwDgYDVR0PAQH/BAQDAgAGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFJ3+ocRyCTJw067dLSwr/nalx6YMMA0GCSqGSIb3DQEBBQUAA4GBAMaQzt+zaj1GU77yzlr8iiMBXgdQrwsZZWJo5exnAucJAEYQZmOfyLiM D6oYq+ZnfvM0n8G/Y79q8nhwvuxpYOnRSAXFp6xSkrIOeZtJMY1h00LKp/JX3Ng1svZ2agE126JHsQ0bhzN5TKsYfbwfTwfjdWAGy6Vf1nYi/rO+ryMO")
 *             .clusterName("testCluster")
 *             .identity(ConnectedClusterIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("East US")
 *             .resourceGroupName("k8sc-rg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### CreateClusterPrivateLinkExample
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectedCluster = new AzureNative.Kubernetes.ConnectedCluster("connectedCluster", new()
 *     {
 *         AgentPublicKeyCertificate = "MIICYzCCAcygAwIBAgIBADANBgkqhkiG9w0BAQUFADAuMQswCQYDVQQGEwJVUzEMMAoGA1UEChMDSUJNMREwDwYDVQQLEwhMb2NhbCBDQTAeFw05OTEyMjIwNTAwMDBaFw0wMDEyMjMwNDU5NTlaMC4xCzAJBgNVBAYTAlVTMQwwCgYDVQQKEwNJQk0xETAPBgNVBAsTCExvY2FsIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQD2bZEo7xGaX2/0GHkrNFZvlxBou9v1Jmt/PDiTMPve8r9FeJAQ0QdvFST/0JPQYD20rH0bimdDLgNdNynmyRoS2S/IInfpmf69iyc2G0TPyRvmHIiOZbdCd+YBHQi1adkj17NDcWj6S14tVurFX73zx0sNoMS79q3tuXKrDsxeuwIDAQABo4GQMIGNMEsGCVUdDwGG+EIBDQQ+EzxHZW5lcmF0ZWQgYnkgdGhlIFNlY3VyZVdheSBTZWN1cml0eSBTZXJ2ZXIgZm9yIE9TLzM5MCAoUkFDRikwDgYDVR0PAQH/BAQDAgAGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFJ3+ocRyCTJw067dLSwr/nalx6YMMA0GCSqGSIb3DQEBBQUAA4GBAMaQzt+zaj1GU77yzlr8iiMBXgdQrwsZZWJo5exnAucJAEYQZmOfyLiM D6oYq+ZnfvM0n8G/Y79q8nhwvuxpYOnRSAXFp6xSkrIOeZtJMY1h00LKp/JX3Ng1svZ2agE126JHsQ0bhzN5TKsYfbwfTwfjdWAGy6Vf1nYi/rO+ryMO",
 *         ClusterName = "testClusterPvtLink",
 *         Identity = new AzureNative.Kubernetes.Inputs.ConnectedClusterIdentityArgs
 *         {
 *             Type = AzureNative.Kubernetes.ResourceIdentityType.SystemAssigned,
 *         },
 *         Location = "East US",
 *         PrivateLinkScopeResourceId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.HybridCompute/privateLinkScopes/privateLinkScopeName",
 *         PrivateLinkState = AzureNative.Kubernetes.PrivateLinkState.Enabled,
 *         ResourceGroupName = "k8sc-rg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetes/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetes.NewConnectedCluster(ctx, "connectedCluster", &kubernetes.ConnectedClusterArgs{
 * 			AgentPublicKeyCertificate: pulumi.String("MIICYzCCAcygAwIBAgIBADANBgkqhkiG9w0BAQUFADAuMQswCQYDVQQGEwJVUzEMMAoGA1UEChMDSUJNMREwDwYDVQQLEwhMb2NhbCBDQTAeFw05OTEyMjIwNTAwMDBaFw0wMDEyMjMwNDU5NTlaMC4xCzAJBgNVBAYTAlVTMQwwCgYDVQQKEwNJQk0xETAPBgNVBAsTCExvY2FsIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQD2bZEo7xGaX2/0GHkrNFZvlxBou9v1Jmt/PDiTMPve8r9FeJAQ0QdvFST/0JPQYD20rH0bimdDLgNdNynmyRoS2S/IInfpmf69iyc2G0TPyRvmHIiOZbdCd+YBHQi1adkj17NDcWj6S14tVurFX73zx0sNoMS79q3tuXKrDsxeuwIDAQABo4GQMIGNMEsGCVUdDwGG+EIBDQQ+EzxHZW5lcmF0ZWQgYnkgdGhlIFNlY3VyZVdheSBTZWN1cml0eSBTZXJ2ZXIgZm9yIE9TLzM5MCAoUkFDRikwDgYDVR0PAQH/BAQDAgAGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFJ3+ocRyCTJw067dLSwr/nalx6YMMA0GCSqGSIb3DQEBBQUAA4GBAMaQzt+zaj1GU77yzlr8iiMBXgdQrwsZZWJo5exnAucJAEYQZmOfyLiM D6oYq+ZnfvM0n8G/Y79q8nhwvuxpYOnRSAXFp6xSkrIOeZtJMY1h00LKp/JX3Ng1svZ2agE126JHsQ0bhzN5TKsYfbwfTwfjdWAGy6Vf1nYi/rO+ryMO"),
 * 			ClusterName:               pulumi.String("testClusterPvtLink"),
 * 			Identity: &kubernetes.ConnectedClusterIdentityArgs{
 * 				Type: kubernetes.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			Location:                   pulumi.String("East US"),
 * 			PrivateLinkScopeResourceId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.HybridCompute/privateLinkScopes/privateLinkScopeName"),
 * 			PrivateLinkState:           pulumi.String(kubernetes.PrivateLinkStateEnabled),
 * 			ResourceGroupName:          pulumi.String("k8sc-rg"),
 * 			Tags:                       nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetes.ConnectedCluster;
 * import com.pulumi.azurenative.kubernetes.ConnectedClusterArgs;
 * import com.pulumi.azurenative.kubernetes.inputs.ConnectedClusterIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectedCluster = new ConnectedCluster("connectedCluster", ConnectedClusterArgs.builder()
 *             .agentPublicKeyCertificate("MIICYzCCAcygAwIBAgIBADANBgkqhkiG9w0BAQUFADAuMQswCQYDVQQGEwJVUzEMMAoGA1UEChMDSUJNMREwDwYDVQQLEwhMb2NhbCBDQTAeFw05OTEyMjIwNTAwMDBaFw0wMDEyMjMwNDU5NTlaMC4xCzAJBgNVBAYTAlVTMQwwCgYDVQQKEwNJQk0xETAPBgNVBAsTCExvY2FsIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQD2bZEo7xGaX2/0GHkrNFZvlxBou9v1Jmt/PDiTMPve8r9FeJAQ0QdvFST/0JPQYD20rH0bimdDLgNdNynmyRoS2S/IInfpmf69iyc2G0TPyRvmHIiOZbdCd+YBHQi1adkj17NDcWj6S14tVurFX73zx0sNoMS79q3tuXKrDsxeuwIDAQABo4GQMIGNMEsGCVUdDwGG+EIBDQQ+EzxHZW5lcmF0ZWQgYnkgdGhlIFNlY3VyZVdheSBTZWN1cml0eSBTZXJ2ZXIgZm9yIE9TLzM5MCAoUkFDRikwDgYDVR0PAQH/BAQDAgAGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFJ3+ocRyCTJw067dLSwr/nalx6YMMA0GCSqGSIb3DQEBBQUAA4GBAMaQzt+zaj1GU77yzlr8iiMBXgdQrwsZZWJo5exnAucJAEYQZmOfyLiM D6oYq+ZnfvM0n8G/Y79q8nhwvuxpYOnRSAXFp6xSkrIOeZtJMY1h00LKp/JX3Ng1svZ2agE126JHsQ0bhzN5TKsYfbwfTwfjdWAGy6Vf1nYi/rO+ryMO")
 *             .clusterName("testClusterPvtLink")
 *             .identity(ConnectedClusterIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("East US")
 *             .privateLinkScopeResourceId("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.HybridCompute/privateLinkScopes/privateLinkScopeName")
 *             .privateLinkState("Enabled")
 *             .resourceGroupName("k8sc-rg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kubernetes:ConnectedCluster connectedCluster1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Kubernetes/connectedClusters/{clusterName}
 * ```
 * @property agentPublicKeyCertificate Base64 encoded public certificate used by the agent to do the initial handshake to the backend services in Azure.
 * @property clusterName The name of the Kubernetes cluster on which get is called.
 * @property distribution The Kubernetes distribution running on this connected cluster.
 * @property identity The identity of the connected cluster.
 * @property infrastructure The infrastructure on which the Kubernetes cluster represented by this connected cluster is running on.
 * @property location The geo-location where the resource lives
 * @property privateLinkScopeResourceId The resource id of the private link scope this connected cluster is assigned to, if any.
 * @property privateLinkState Property which describes the state of private link on a connected cluster resource.
 * @property provisioningState Provisioning state of the connected cluster resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class ConnectedClusterArgs(
    public val agentPublicKeyCertificate: Output<String>? = null,
    public val clusterName: Output<String>? = null,
    public val distribution: Output<String>? = null,
    public val identity: Output<ConnectedClusterIdentityArgs>? = null,
    public val infrastructure: Output<String>? = null,
    public val location: Output<String>? = null,
    public val privateLinkScopeResourceId: Output<String>? = null,
    public val privateLinkState: Output<Either<String, PrivateLinkState>>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetes.ConnectedClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetes.ConnectedClusterArgs =
        com.pulumi.azurenative.kubernetes.ConnectedClusterArgs.builder()
            .agentPublicKeyCertificate(agentPublicKeyCertificate?.applyValue({ args0 -> args0 }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .distribution(distribution?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .infrastructure(infrastructure?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .privateLinkScopeResourceId(privateLinkScopeResourceId?.applyValue({ args0 -> args0 }))
            .privateLinkState(
                privateLinkState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConnectedClusterArgs].
 */
@PulumiTagMarker
public class ConnectedClusterArgsBuilder internal constructor() {
    private var agentPublicKeyCertificate: Output<String>? = null

    private var clusterName: Output<String>? = null

    private var distribution: Output<String>? = null

    private var identity: Output<ConnectedClusterIdentityArgs>? = null

    private var infrastructure: Output<String>? = null

    private var location: Output<String>? = null

    private var privateLinkScopeResourceId: Output<String>? = null

    private var privateLinkState: Output<Either<String, PrivateLinkState>>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Base64 encoded public certificate used by the agent to do the initial handshake to the backend services in Azure.
     */
    @JvmName("tgobinedxyjnquia")
    public suspend fun agentPublicKeyCertificate(`value`: Output<String>) {
        this.agentPublicKeyCertificate = value
    }

    /**
     * @param value The name of the Kubernetes cluster on which get is called.
     */
    @JvmName("fodjodgtqgjrfdoe")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The Kubernetes distribution running on this connected cluster.
     */
    @JvmName("lciphogtpkrghcek")
    public suspend fun distribution(`value`: Output<String>) {
        this.distribution = value
    }

    /**
     * @param value The identity of the connected cluster.
     */
    @JvmName("yxbcadvsrajmynhq")
    public suspend fun identity(`value`: Output<ConnectedClusterIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The infrastructure on which the Kubernetes cluster represented by this connected cluster is running on.
     */
    @JvmName("hmfmbummdfsmeynq")
    public suspend fun infrastructure(`value`: Output<String>) {
        this.infrastructure = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("yxvbhnarukyjvefq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The resource id of the private link scope this connected cluster is assigned to, if any.
     */
    @JvmName("mjniuxwhnahrtycs")
    public suspend fun privateLinkScopeResourceId(`value`: Output<String>) {
        this.privateLinkScopeResourceId = value
    }

    /**
     * @param value Property which describes the state of private link on a connected cluster resource.
     */
    @JvmName("uhnevepxoakjnuun")
    public suspend fun privateLinkState(`value`: Output<Either<String, PrivateLinkState>>) {
        this.privateLinkState = value
    }

    /**
     * @param value Provisioning state of the connected cluster resource.
     */
    @JvmName("egtxuidktybbbsvv")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rdhrkqvlnrmrsxfx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fpbadxlcgodrnrus")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Base64 encoded public certificate used by the agent to do the initial handshake to the backend services in Azure.
     */
    @JvmName("fowhaqtiqxfnvakk")
    public suspend fun agentPublicKeyCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentPublicKeyCertificate = mapped
    }

    /**
     * @param value The name of the Kubernetes cluster on which get is called.
     */
    @JvmName("sbthctmyacfapuaj")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The Kubernetes distribution running on this connected cluster.
     */
    @JvmName("fjxhjtlkddlgrevi")
    public suspend fun distribution(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distribution = mapped
    }

    /**
     * @param value The identity of the connected cluster.
     */
    @JvmName("pajrkbfnjipbunoq")
    public suspend fun identity(`value`: ConnectedClusterIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the connected cluster.
     */
    @JvmName("glrnxwqxtdwciwxm")
    public suspend fun identity(argument: suspend ConnectedClusterIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectedClusterIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The infrastructure on which the Kubernetes cluster represented by this connected cluster is running on.
     */
    @JvmName("sjyabjryfkjavssr")
    public suspend fun infrastructure(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infrastructure = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("qihiojxwxsuqeuyb")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The resource id of the private link scope this connected cluster is assigned to, if any.
     */
    @JvmName("rsjsvqhcfunsxplv")
    public suspend fun privateLinkScopeResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkScopeResourceId = mapped
    }

    /**
     * @param value Property which describes the state of private link on a connected cluster resource.
     */
    @JvmName("daiodsoxwscljsbt")
    public suspend fun privateLinkState(`value`: Either<String, PrivateLinkState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkState = mapped
    }

    /**
     * @param value Property which describes the state of private link on a connected cluster resource.
     */
    @JvmName("tfkpryknmwypwbwl")
    public fun privateLinkState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrivateLinkState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkState = mapped
    }

    /**
     * @param value Property which describes the state of private link on a connected cluster resource.
     */
    @JvmName("rimufoyaywbxophr")
    public fun privateLinkState(`value`: PrivateLinkState) {
        val toBeMapped = Either.ofRight<String, PrivateLinkState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkState = mapped
    }

    /**
     * @param value Provisioning state of the connected cluster resource.
     */
    @JvmName("ifkmlxntqovahfbu")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the connected cluster resource.
     */
    @JvmName("uxpjdouimetokilg")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the connected cluster resource.
     */
    @JvmName("vnacokuepmmobphj")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eascglhauxblkbsy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nhanypfyracdeoui")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("vxkeyvfrcnhfrhql")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConnectedClusterArgs = ConnectedClusterArgs(
        agentPublicKeyCertificate = agentPublicKeyCertificate,
        clusterName = clusterName,
        distribution = distribution,
        identity = identity,
        infrastructure = infrastructure,
        location = location,
        privateLinkScopeResourceId = privateLinkScopeResourceId,
        privateLinkState = privateLinkState,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
