@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetes.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of identity used for the connected cluster. The type 'SystemAssigned, includes a system created identity. The type 'None' means no identity is assigned to the connected cluster.
 */
public enum class ResourceIdentityType(
    public val javaValue: com.pulumi.azurenative.kubernetes.enums.ResourceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetes.enums.ResourceIdentityType> {
    None(com.pulumi.azurenative.kubernetes.enums.ResourceIdentityType.None),
    SystemAssigned(com.pulumi.azurenative.kubernetes.enums.ResourceIdentityType.SystemAssigned),
    ;

    override fun toJava(): com.pulumi.azurenative.kubernetes.enums.ResourceIdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetes.enums.ResourceIdentityType): ResourceIdentityType = ResourceIdentityType.values().first { it.javaValue == javaType }
    }
}
