@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetes.kotlin.inputs

import com.pulumi.azurenative.kubernetes.inputs.ConnectedClusterIdentityArgs.builder
import com.pulumi.azurenative.kubernetes.kotlin.enums.ResourceIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Identity for the connected cluster.
 * @property type The type of identity used for the connected cluster. The type 'SystemAssigned, includes a system created identity. The type 'None' means no identity is assigned to the connected cluster.
 */
public data class ConnectedClusterIdentityArgs(
    public val type: Output<ResourceIdentityType>,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetes.inputs.ConnectedClusterIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetes.inputs.ConnectedClusterIdentityArgs =
        com.pulumi.azurenative.kubernetes.inputs.ConnectedClusterIdentityArgs.builder()
            .type(type.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConnectedClusterIdentityArgs].
 */
@PulumiTagMarker
public class ConnectedClusterIdentityArgsBuilder internal constructor() {
    private var type: Output<ResourceIdentityType>? = null

    /**
     * @param value The type of identity used for the connected cluster. The type 'SystemAssigned, includes a system created identity. The type 'None' means no identity is assigned to the connected cluster.
     */
    @JvmName("ssvuyvptpqaxqjhu")
    public suspend fun type(`value`: Output<ResourceIdentityType>) {
        this.type = value
    }

    /**
     * @param value The type of identity used for the connected cluster. The type 'SystemAssigned, includes a system created identity. The type 'None' means no identity is assigned to the connected cluster.
     */
    @JvmName("hieqllajgemsnioy")
    public suspend fun type(`value`: ResourceIdentityType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ConnectedClusterIdentityArgs = ConnectedClusterIdentityArgs(
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
