@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetes.kotlin.inputs

import com.pulumi.azurenative.kubernetes.inputs.ListConnectedClusterUserCredentialPlainArgs.builder
import com.pulumi.azurenative.kubernetes.kotlin.enums.AuthenticationMethod
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authenticationMethod The mode of client authentication.
 * @property clientProxy Boolean value to indicate whether the request is for client side proxy or not
 * @property clusterName The name of the Kubernetes cluster on which get is called.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListConnectedClusterUserCredentialPlainArgs(
    public val authenticationMethod: Either<String, AuthenticationMethod>,
    public val clientProxy: Boolean,
    public val clusterName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.kubernetes.inputs.ListConnectedClusterUserCredentialPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetes.inputs.ListConnectedClusterUserCredentialPlainArgs =
        com.pulumi.azurenative.kubernetes.inputs.ListConnectedClusterUserCredentialPlainArgs.builder()
            .authenticationMethod(
                authenticationMethod.let({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .clientProxy(clientProxy.let({ args0 -> args0 }))
            .clusterName(clusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListConnectedClusterUserCredentialPlainArgs].
 */
@PulumiTagMarker
public class ListConnectedClusterUserCredentialPlainArgsBuilder internal constructor() {
    private var authenticationMethod: Either<String, AuthenticationMethod>? = null

    private var clientProxy: Boolean? = null

    private var clusterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The mode of client authentication.
     */
    @JvmName("gphktiaxlpoflybs")
    public suspend fun authenticationMethod(`value`: Either<String, AuthenticationMethod>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authenticationMethod = mapped
    }

    /**
     * @param value The mode of client authentication.
     */
    @JvmName("tvgaptxfqesbbfgv")
    public fun authenticationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authenticationMethod = mapped
    }

    /**
     * @param value The mode of client authentication.
     */
    @JvmName("evjdfuatexwgssgy")
    public fun authenticationMethod(`value`: AuthenticationMethod) {
        val toBeMapped = Either.ofRight<String, AuthenticationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authenticationMethod = mapped
    }

    /**
     * @param value Boolean value to indicate whether the request is for client side proxy or not
     */
    @JvmName("aepuugdgokrnelek")
    public suspend fun clientProxy(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clientProxy = mapped
    }

    /**
     * @param value The name of the Kubernetes cluster on which get is called.
     */
    @JvmName("upasjwqelqopnifl")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tbgtwycblntyfwve")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListConnectedClusterUserCredentialPlainArgs =
        ListConnectedClusterUserCredentialPlainArgs(
            authenticationMethod = authenticationMethod ?: throw
                PulumiNullFieldException("authenticationMethod"),
            clientProxy = clientProxy ?: throw PulumiNullFieldException("clientProxy"),
            clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
