@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetes.kotlin.inputs

import com.pulumi.azurenative.kubernetes.inputs.ListConnectedClusterUserCredentialsPlainArgs.builder
import com.pulumi.azurenative.kubernetes.kotlin.enums.AuthenticationMethod
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authenticationMethod The mode of client authentication.
 * @property clientProxy Boolean value to indicate whether the request is for client side proxy or not
 * @property clusterName The name of the Kubernetes cluster on which get is called.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListConnectedClusterUserCredentialsPlainArgs(
    public val authenticationMethod: Either<String, AuthenticationMethod>,
    public val clientProxy: Boolean,
    public val clusterName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.kubernetes.inputs.ListConnectedClusterUserCredentialsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetes.inputs.ListConnectedClusterUserCredentialsPlainArgs =
        com.pulumi.azurenative.kubernetes.inputs.ListConnectedClusterUserCredentialsPlainArgs.builder()
            .authenticationMethod(
                authenticationMethod.let({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .clientProxy(clientProxy.let({ args0 -> args0 }))
            .clusterName(clusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListConnectedClusterUserCredentialsPlainArgs].
 */
@PulumiTagMarker
public class ListConnectedClusterUserCredentialsPlainArgsBuilder internal constructor() {
    private var authenticationMethod: Either<String, AuthenticationMethod>? = null

    private var clientProxy: Boolean? = null

    private var clusterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The mode of client authentication.
     */
    @JvmName("btiklkmowcyuvakq")
    public suspend fun authenticationMethod(`value`: Either<String, AuthenticationMethod>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authenticationMethod = mapped
    }

    /**
     * @param value The mode of client authentication.
     */
    @JvmName("siyvugrpwhedbovt")
    public fun authenticationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authenticationMethod = mapped
    }

    /**
     * @param value The mode of client authentication.
     */
    @JvmName("trkgdmalcrixhcsq")
    public fun authenticationMethod(`value`: AuthenticationMethod) {
        val toBeMapped = Either.ofRight<String, AuthenticationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authenticationMethod = mapped
    }

    /**
     * @param value Boolean value to indicate whether the request is for client side proxy or not
     */
    @JvmName("mthlevawolmcyjmb")
    public suspend fun clientProxy(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clientProxy = mapped
    }

    /**
     * @param value The name of the Kubernetes cluster on which get is called.
     */
    @JvmName("mbtjgwsmywnrmvja")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rjmlvfnmpvmjfnxu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListConnectedClusterUserCredentialsPlainArgs =
        ListConnectedClusterUserCredentialsPlainArgs(
            authenticationMethod = authenticationMethod ?: throw
                PulumiNullFieldException("authenticationMethod"),
            clientProxy = clientProxy ?: throw PulumiNullFieldException("clientProxy"),
            clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
