@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetes.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Identity for the connected cluster.
 * @property principalId The principal id of connected cluster identity. This property will only be provided for a system assigned identity.
 * @property tenantId The tenant id associated with the connected cluster. This property will only be provided for a system assigned identity.
 * @property type The type of identity used for the connected cluster. The type 'SystemAssigned, includes a system created identity. The type 'None' means no identity is assigned to the connected cluster.
 */
public data class ConnectedClusterIdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetes.outputs.ConnectedClusterIdentityResponse): ConnectedClusterIdentityResponse = ConnectedClusterIdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
        )
    }
}
