@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetes.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents a connected cluster.
 * @property agentPublicKeyCertificate Base64 encoded public certificate used by the agent to do the initial handshake to the backend services in Azure.
 * @property agentVersion Version of the agent running on the connected cluster resource
 * @property connectivityStatus Represents the connectivity status of the connected cluster.
 * @property distribution The Kubernetes distribution running on this connected cluster.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The identity of the connected cluster.
 * @property infrastructure The infrastructure on which the Kubernetes cluster represented by this connected cluster is running on.
 * @property kubernetesVersion The Kubernetes version of the connected cluster resource
 * @property lastConnectivityTime Time representing the last instance when heart beat was received from the cluster
 * @property location The geo-location where the resource lives
 * @property managedIdentityCertificateExpirationTime Expiration time of the managed identity certificate
 * @property name The name of the resource
 * @property offering Connected cluster offering
 * @property privateLinkScopeResourceId The resource id of the private link scope this connected cluster is assigned to, if any.
 * @property privateLinkState Property which describes the state of private link on a connected cluster resource.
 * @property provisioningState Provisioning state of the connected cluster resource.
 * @property systemData Metadata pertaining to creation and last modification of the resource
 * @property tags Resource tags.
 * @property totalCoreCount Number of CPU cores present in the connected cluster resource
 * @property totalNodeCount Number of nodes present in the connected cluster resource
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetConnectedClusterResult(
    public val agentPublicKeyCertificate: String,
    public val agentVersion: String,
    public val connectivityStatus: String,
    public val distribution: String? = null,
    public val id: String,
    public val identity: ConnectedClusterIdentityResponse,
    public val infrastructure: String? = null,
    public val kubernetesVersion: String,
    public val lastConnectivityTime: String,
    public val location: String,
    public val managedIdentityCertificateExpirationTime: String,
    public val name: String,
    public val offering: String,
    public val privateLinkScopeResourceId: String? = null,
    public val privateLinkState: String? = null,
    public val provisioningState: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val totalCoreCount: Int,
    public val totalNodeCount: Int,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetes.outputs.GetConnectedClusterResult): GetConnectedClusterResult = GetConnectedClusterResult(
            agentPublicKeyCertificate = javaType.agentPublicKeyCertificate(),
            agentVersion = javaType.agentVersion(),
            connectivityStatus = javaType.connectivityStatus(),
            distribution = javaType.distribution().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().let({ args0 ->
                com.pulumi.azurenative.kubernetes.kotlin.outputs.ConnectedClusterIdentityResponse.Companion.toKotlin(args0)
            }),
            infrastructure = javaType.infrastructure().map({ args0 -> args0 }).orElse(null),
            kubernetesVersion = javaType.kubernetesVersion(),
            lastConnectivityTime = javaType.lastConnectivityTime(),
            location = javaType.location(),
            managedIdentityCertificateExpirationTime = javaType.managedIdentityCertificateExpirationTime(),
            name = javaType.name(),
            offering = javaType.offering(),
            privateLinkScopeResourceId = javaType.privateLinkScopeResourceId().map({ args0 ->
                args0
            }).orElse(null),
            privateLinkState = javaType.privateLinkState().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.kubernetes.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            totalCoreCount = javaType.totalCoreCount(),
            totalNodeCount = javaType.totalNodeCount(),
            type = javaType.type(),
        )
    }
}
