@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetes.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Contains the REP (rendezvous endpoint) and “Sender” access token.
 * @property expirationTime Timestamp when this token will be expired.
 * @property hybridConnectionName Name of the connection
 * @property relay Name of the relay.
 * @property token Sender access token
 */
public data class HybridConnectionConfigResponse(
    public val expirationTime: Double,
    public val hybridConnectionName: String,
    public val relay: String,
    public val token: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetes.outputs.HybridConnectionConfigResponse): HybridConnectionConfigResponse = HybridConnectionConfigResponse(
            expirationTime = javaType.expirationTime(),
            hybridConnectionName = javaType.hybridConnectionName(),
            relay = javaType.relay(),
            token = javaType.token(),
        )
    }
}
