@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetes.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The list of credential result response.
 * @property hybridConnectionConfig Contains the REP (rendezvous endpoint) and “Sender” access token.
 * @property kubeconfigs Base64-encoded Kubernetes configuration file.
 */
public data class ListConnectedClusterUserCredentialResult(
    public val hybridConnectionConfig: HybridConnectionConfigResponse,
    public val kubeconfigs: List<CredentialResultResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetes.outputs.ListConnectedClusterUserCredentialResult): ListConnectedClusterUserCredentialResult = ListConnectedClusterUserCredentialResult(
            hybridConnectionConfig = javaType.hybridConnectionConfig().let({ args0 ->
                com.pulumi.azurenative.kubernetes.kotlin.outputs.HybridConnectionConfigResponse.Companion.toKotlin(args0)
            }),
            kubeconfigs = javaType.kubeconfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetes.kotlin.outputs.CredentialResultResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
