@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin

import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ErrorDetailResponse
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ExtensionResponseAksAssignedIdentity
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ExtensionStatusResponse
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.PlanResponse
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ScopeResponse
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ErrorDetailResponse.Companion.toKotlin as errorDetailResponseToKotlin
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ExtensionResponseAksAssignedIdentity.Companion.toKotlin as extensionResponseAksAssignedIdentityToKotlin
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ExtensionStatusResponse.Companion.toKotlin as extensionStatusResponseToKotlin
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.PlanResponse.Companion.toKotlin as planResponseToKotlin
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ScopeResponse.Companion.toKotlin as scopeResponseToKotlin
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Extension].
 */
@PulumiTagMarker
public class ExtensionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExtensionArgs = ExtensionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExtensionArgsBuilder.() -> Unit) {
        val builder = ExtensionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Extension {
        val builtJavaResource =
            com.pulumi.azurenative.kubernetesconfiguration.Extension(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Extension(builtJavaResource)
    }
}

/**
 * The Extension object.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-07-01-preview.
 * Other available API versions: 2020-07-01-preview, 2022-04-02-preview, 2022-07-01.
 * ## Example Usage
 * ### Create Extension
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var extension = new AzureNative.KubernetesConfiguration.Extension("extension", new()
 *     {
 *         AutoUpgradeMinorVersion = true,
 *         ClusterName = "clusterName1",
 *         ClusterResourceName = "connectedClusters",
 *         ClusterRp = "Microsoft.Kubernetes",
 *         ConfigurationProtectedSettings =
 *         {
 *             { "omsagent.secret.key", "secretKeyValue01" },
 *         },
 *         ConfigurationSettings =
 *         {
 *             { "omsagent.env.clusterName", "clusterName1" },
 *             { "omsagent.secret.wsid", "fakeTokenPlaceholder" },
 *         },
 *         ExtensionName = "ClusterMonitor",
 *         ExtensionType = "azuremonitor-containers",
 *         ReleaseTrain = "Preview",
 *         ResourceGroupName = "rg1",
 *         Scope = new AzureNative.KubernetesConfiguration.Inputs.ScopeArgs
 *         {
 *             Cluster = new AzureNative.KubernetesConfiguration.Inputs.ScopeClusterArgs
 *             {
 *                 ReleaseNamespace = "kube-system",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetesconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetesconfiguration.NewExtension(ctx, "extension", &kubernetesconfiguration.ExtensionArgs{
 * 			AutoUpgradeMinorVersion: pulumi.Bool(true),
 * 			ClusterName:             pulumi.String("clusterName1"),
 * 			ClusterResourceName:     pulumi.String("connectedClusters"),
 * 			ClusterRp:               pulumi.String("Microsoft.Kubernetes"),
 * 			ConfigurationProtectedSettings: pulumi.StringMap{
 * 				"omsagent.secret.key": pulumi.String("secretKeyValue01"),
 * 			},
 * 			ConfigurationSettings: pulumi.StringMap{
 * 				"omsagent.env.clusterName": pulumi.String("clusterName1"),
 * 				"omsagent.secret.wsid":     pulumi.String("fakeTokenPlaceholder"),
 * 			},
 * 			ExtensionName:     pulumi.String("ClusterMonitor"),
 * 			ExtensionType:     pulumi.String("azuremonitor-containers"),
 * 			ReleaseTrain:      pulumi.String("Preview"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Scope: &kubernetesconfiguration.ScopeArgs{
 * 				Cluster: &kubernetesconfiguration.ScopeClusterArgs{
 * 					ReleaseNamespace: pulumi.String("kube-system"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetesconfiguration.Extension;
 * import com.pulumi.azurenative.kubernetesconfiguration.ExtensionArgs;
 * import com.pulumi.azurenative.kubernetesconfiguration.inputs.ScopeArgs;
 * import com.pulumi.azurenative.kubernetesconfiguration.inputs.ScopeClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var extension = new Extension("extension", ExtensionArgs.builder()
 *             .autoUpgradeMinorVersion(true)
 *             .clusterName("clusterName1")
 *             .clusterResourceName("connectedClusters")
 *             .clusterRp("Microsoft.Kubernetes")
 *             .configurationProtectedSettings(Map.of("omsagent.secret.key", "secretKeyValue01"))
 *             .configurationSettings(Map.ofEntries(
 *                 Map.entry("omsagent.env.clusterName", "clusterName1"),
 *                 Map.entry("omsagent.secret.wsid", "fakeTokenPlaceholder")
 *             ))
 *             .extensionName("ClusterMonitor")
 *             .extensionType("azuremonitor-containers")
 *             .releaseTrain("Preview")
 *             .resourceGroupName("rg1")
 *             .scope(ScopeArgs.builder()
 *                 .cluster(ScopeClusterArgs.builder()
 *                     .releaseNamespace("kube-system")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Extension with Plan
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var extension = new AzureNative.KubernetesConfiguration.Extension("extension", new()
 *     {
 *         AutoUpgradeMinorVersion = true,
 *         ClusterName = "clusterName1",
 *         ClusterResourceName = "connectedClusters",
 *         ClusterRp = "Microsoft.Kubernetes",
 *         ExtensionName = "azureVote",
 *         ExtensionType = "azure-vote",
 *         Plan = new AzureNative.KubernetesConfiguration.Inputs.PlanArgs
 *         {
 *             Name = "azure-vote-standard",
 *             Product = "azure-vote-standard-offer-id",
 *             Publisher = "Microsoft",
 *         },
 *         ReleaseTrain = "Preview",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetesconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetesconfiguration.NewExtension(ctx, "extension", &kubernetesconfiguration.ExtensionArgs{
 * 			AutoUpgradeMinorVersion: pulumi.Bool(true),
 * 			ClusterName:             pulumi.String("clusterName1"),
 * 			ClusterResourceName:     pulumi.String("connectedClusters"),
 * 			ClusterRp:               pulumi.String("Microsoft.Kubernetes"),
 * 			ExtensionName:           pulumi.String("azureVote"),
 * 			ExtensionType:           pulumi.String("azure-vote"),
 * 			Plan: &kubernetesconfiguration.PlanArgs{
 * 				Name:      pulumi.String("azure-vote-standard"),
 * 				Product:   pulumi.String("azure-vote-standard-offer-id"),
 * 				Publisher: pulumi.String("Microsoft"),
 * 			},
 * 			ReleaseTrain:      pulumi.String("Preview"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetesconfiguration.Extension;
 * import com.pulumi.azurenative.kubernetesconfiguration.ExtensionArgs;
 * import com.pulumi.azurenative.kubernetesconfiguration.inputs.PlanArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var extension = new Extension("extension", ExtensionArgs.builder()
 *             .autoUpgradeMinorVersion(true)
 *             .clusterName("clusterName1")
 *             .clusterResourceName("connectedClusters")
 *             .clusterRp("Microsoft.Kubernetes")
 *             .extensionName("azureVote")
 *             .extensionType("azure-vote")
 *             .plan(PlanArgs.builder()
 *                 .name("azure-vote-standard")
 *                 .product("azure-vote-standard-offer-id")
 *                 .publisher("Microsoft")
 *                 .build())
 *             .releaseTrain("Preview")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kubernetesconfiguration:Extension azureVote /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{clusterRp}/{clusterResourceName}/{clusterName}/providers/Microsoft.KubernetesConfiguration/extensions/{extensionName}
 * ```
 */
public class Extension internal constructor(
    override val javaResource: com.pulumi.azurenative.kubernetesconfiguration.Extension,
) : KotlinCustomResource(javaResource, ExtensionMapper) {
    /**
     * Identity of the Extension resource in an AKS cluster
     */
    public val aksAssignedIdentity: Output<ExtensionResponseAksAssignedIdentity>?
        get() = javaResource.aksAssignedIdentity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extensionResponseAksAssignedIdentityToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Flag to note if this extension participates in auto upgrade of minor version, or not.
     */
    public val autoUpgradeMinorVersion: Output<Boolean>?
        get() = javaResource.autoUpgradeMinorVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration settings that are sensitive, as name-value pairs for configuring this extension.
     */
    public val configurationProtectedSettings: Output<Map<String, String>>?
        get() = javaResource.configurationProtectedSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Configuration settings, as name-value pairs for configuring this extension.
     */
    public val configurationSettings: Output<Map<String, String>>?
        get() = javaResource.configurationSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Currently installed version of the extension.
     */
    public val currentVersion: Output<String>
        get() = javaResource.currentVersion().applyValue({ args0 -> args0 })

    /**
     * Custom Location settings properties.
     */
    public val customLocationSettings: Output<Map<String, String>>
        get() = javaResource.customLocationSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Error information from the Agent - e.g. errors during installation.
     */
    public val errorInfo: Output<ErrorDetailResponse>
        get() = javaResource.errorInfo().applyValue({ args0 ->
            args0.let({ args0 ->
                errorDetailResponseToKotlin(args0)
            })
        })

    /**
     * Type of the Extension, of which this resource is an instance of.  It must be one of the Extension Types registered with Microsoft.KubernetesConfiguration by the Extension publisher.
     */
    public val extensionType: Output<String>?
        get() = javaResource.extensionType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identity of the Extension resource
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Flag to note if this extension is a system extension
     */
    public val isSystemExtension: Output<Boolean>
        get() = javaResource.isSystemExtension().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Uri of the Helm package
     */
    public val packageUri: Output<String>
        get() = javaResource.packageUri().applyValue({ args0 -> args0 })

    /**
     * The plan information.
     */
    public val plan: Output<PlanResponse>?
        get() = javaResource.plan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    planResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Status of installation of this extension.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * ReleaseTrain this extension participates in for auto-upgrade (e.g. Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
     */
    public val releaseTrain: Output<String>?
        get() = javaResource.releaseTrain().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Scope at which the extension is installed.
     */
    public val scope: Output<ScopeResponse>?
        get() = javaResource.scope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    scopeResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Status from this extension.
     */
    public val statuses: Output<List<ExtensionStatusResponse>>?
        get() = javaResource.statuses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> extensionStatusResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Top level metadata https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * User-specified version of the extension for this extension to 'pin'. To use 'version', autoUpgradeMinorVersion must be 'false'.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ExtensionMapper : ResourceMapper<Extension> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.kubernetesconfiguration.Extension::class == javaResource::class

    override fun map(javaResource: Resource): Extension = Extension(
        javaResource as
            com.pulumi.azurenative.kubernetesconfiguration.Extension,
    )
}

/**
 * @see [Extension].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Extension].
 */
public suspend fun extension(name: String, block: suspend ExtensionResourceBuilder.() -> Unit): Extension {
    val builder = ExtensionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Extension].
 * @param name The _unique_ name of the resulting resource.
 */
public fun extension(name: String): Extension {
    val builder = ExtensionResourceBuilder()
    builder.name(name)
    return builder.build()
}
