@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin

import com.pulumi.azurenative.kubernetesconfiguration.KubernetesconfigurationFunctions.getExtensionPlain
import com.pulumi.azurenative.kubernetesconfiguration.KubernetesconfigurationFunctions.getFluxConfigurationPlain
import com.pulumi.azurenative.kubernetesconfiguration.KubernetesconfigurationFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.kubernetesconfiguration.KubernetesconfigurationFunctions.getPrivateLinkScopePlain
import com.pulumi.azurenative.kubernetesconfiguration.KubernetesconfigurationFunctions.getSourceControlConfigurationPlain
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.GetExtensionPlainArgs
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.GetExtensionPlainArgsBuilder
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.GetFluxConfigurationPlainArgs
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.GetFluxConfigurationPlainArgsBuilder
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.GetPrivateLinkScopePlainArgs
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.GetPrivateLinkScopePlainArgsBuilder
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.GetSourceControlConfigurationPlainArgs
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.GetSourceControlConfigurationPlainArgsBuilder
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.GetExtensionResult
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.GetFluxConfigurationResult
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.GetPrivateLinkScopeResult
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.GetSourceControlConfigurationResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.GetExtensionResult.Companion.toKotlin as getExtensionResultToKotlin
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.GetFluxConfigurationResult.Companion.toKotlin as getFluxConfigurationResultToKotlin
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.GetPrivateLinkScopeResult.Companion.toKotlin as getPrivateLinkScopeResultToKotlin
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.GetSourceControlConfigurationResult.Companion.toKotlin as getSourceControlConfigurationResultToKotlin

public object KubernetesconfigurationFunctions {
    /**
     * Gets Kubernetes Cluster Extension.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2020-07-01-preview, 2022-04-02-preview, 2022-07-01.
     * @param argument null
     * @return The Extension object.
     */
    public suspend fun getExtension(argument: GetExtensionPlainArgs): GetExtensionResult =
        getExtensionResultToKotlin(getExtensionPlain(argument.toJava()).await())

    /**
     * @see [getExtension].
     * @param clusterName The name of the kubernetes cluster.
     * @param clusterResourceName The Kubernetes cluster resource name - i.e. managedClusters, connectedClusters, provisionedClusters.
     * @param clusterRp The Kubernetes cluster RP - i.e. Microsoft.ContainerService, Microsoft.Kubernetes, Microsoft.HybridContainerService.
     * @param extensionName Name of the Extension.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The Extension object.
     */
    public suspend fun getExtension(
        clusterName: String,
        clusterResourceName: String,
        clusterRp: String,
        extensionName: String,
        resourceGroupName: String,
    ): GetExtensionResult {
        val argument = GetExtensionPlainArgs(
            clusterName = clusterName,
            clusterResourceName = clusterResourceName,
            clusterRp = clusterRp,
            extensionName = extensionName,
            resourceGroupName = resourceGroupName,
        )
        return getExtensionResultToKotlin(getExtensionPlain(argument.toJava()).await())
    }

    /**
     * @see [getExtension].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kubernetesconfiguration&#46;kotlin&#46;inputs&#46;GetExtensionPlainArgs].
     * @return The Extension object.
     */
    public suspend fun getExtension(argument: suspend GetExtensionPlainArgsBuilder.() -> Unit): GetExtensionResult {
        val builder = GetExtensionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExtensionResultToKotlin(getExtensionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets details of the Flux Configuration.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2021-11-01-preview, 2022-01-01-preview, 2024-04-01-preview.
     * @param argument null
     * @return The Flux Configuration object returned in Get & Put response.
     */
    public suspend fun getFluxConfiguration(argument: GetFluxConfigurationPlainArgs): GetFluxConfigurationResult =
        getFluxConfigurationResultToKotlin(getFluxConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getFluxConfiguration].
     * @param clusterName The name of the kubernetes cluster.
     * @param clusterResourceName The Kubernetes cluster resource name - i.e. managedClusters, connectedClusters, provisionedClusters.
     * @param clusterRp The Kubernetes cluster RP - i.e. Microsoft.ContainerService, Microsoft.Kubernetes, Microsoft.HybridContainerService.
     * @param fluxConfigurationName Name of the Flux Configuration.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The Flux Configuration object returned in Get & Put response.
     */
    public suspend fun getFluxConfiguration(
        clusterName: String,
        clusterResourceName: String,
        clusterRp: String,
        fluxConfigurationName: String,
        resourceGroupName: String,
    ): GetFluxConfigurationResult {
        val argument = GetFluxConfigurationPlainArgs(
            clusterName = clusterName,
            clusterResourceName = clusterResourceName,
            clusterRp = clusterRp,
            fluxConfigurationName = fluxConfigurationName,
            resourceGroupName = resourceGroupName,
        )
        return getFluxConfigurationResultToKotlin(getFluxConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getFluxConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kubernetesconfiguration&#46;kotlin&#46;inputs&#46;GetFluxConfigurationPlainArgs].
     * @return The Flux Configuration object returned in Get & Put response.
     */
    public suspend fun getFluxConfiguration(argument: suspend GetFluxConfigurationPlainArgsBuilder.() -> Unit): GetFluxConfigurationResult {
        val builder = GetFluxConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFluxConfigurationResultToKotlin(getFluxConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a private endpoint connection.
     * Azure REST API version: 2022-04-02-preview.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs): GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param scopeName The name of the Azure Arc PrivateLinkScope resource.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        scopeName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            scopeName = scopeName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kubernetesconfiguration&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit): GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a Azure Arc PrivateLinkScope.
     * Azure REST API version: 2022-04-02-preview.
     * @param argument null
     * @return An Azure Arc PrivateLinkScope definition.
     */
    public suspend fun getPrivateLinkScope(argument: GetPrivateLinkScopePlainArgs): GetPrivateLinkScopeResult =
        getPrivateLinkScopeResultToKotlin(getPrivateLinkScopePlain(argument.toJava()).await())

    /**
     * @see [getPrivateLinkScope].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param scopeName The name of the Azure Arc PrivateLinkScope resource.
     * @return An Azure Arc PrivateLinkScope definition.
     */
    public suspend fun getPrivateLinkScope(resourceGroupName: String, scopeName: String): GetPrivateLinkScopeResult {
        val argument = GetPrivateLinkScopePlainArgs(
            resourceGroupName = resourceGroupName,
            scopeName = scopeName,
        )
        return getPrivateLinkScopeResultToKotlin(getPrivateLinkScopePlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateLinkScope].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kubernetesconfiguration&#46;kotlin&#46;inputs&#46;GetPrivateLinkScopePlainArgs].
     * @return An Azure Arc PrivateLinkScope definition.
     */
    public suspend fun getPrivateLinkScope(argument: suspend GetPrivateLinkScopePlainArgsBuilder.() -> Unit): GetPrivateLinkScopeResult {
        val builder = GetPrivateLinkScopePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateLinkScopeResultToKotlin(getPrivateLinkScopePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets details of the Source Control Configuration.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2019-11-01-preview.
     * @param argument null
     * @return The SourceControl Configuration object returned in Get & Put response.
     */
    public suspend fun getSourceControlConfiguration(argument: GetSourceControlConfigurationPlainArgs): GetSourceControlConfigurationResult =
        getSourceControlConfigurationResultToKotlin(getSourceControlConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getSourceControlConfiguration].
     * @param clusterName The name of the kubernetes cluster.
     * @param clusterResourceName The Kubernetes cluster resource name - i.e. managedClusters, connectedClusters, provisionedClusters.
     * @param clusterRp The Kubernetes cluster RP - i.e. Microsoft.ContainerService, Microsoft.Kubernetes, Microsoft.HybridContainerService.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sourceControlConfigurationName Name of the Source Control Configuration.
     * @return The SourceControl Configuration object returned in Get & Put response.
     */
    public suspend fun getSourceControlConfiguration(
        clusterName: String,
        clusterResourceName: String,
        clusterRp: String,
        resourceGroupName: String,
        sourceControlConfigurationName: String,
    ): GetSourceControlConfigurationResult {
        val argument = GetSourceControlConfigurationPlainArgs(
            clusterName = clusterName,
            clusterResourceName = clusterResourceName,
            clusterRp = clusterRp,
            resourceGroupName = resourceGroupName,
            sourceControlConfigurationName = sourceControlConfigurationName,
        )
        return getSourceControlConfigurationResultToKotlin(getSourceControlConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getSourceControlConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kubernetesconfiguration&#46;kotlin&#46;inputs&#46;GetSourceControlConfigurationPlainArgs].
     * @return The SourceControl Configuration object returned in Get & Put response.
     */
    public suspend fun getSourceControlConfiguration(argument: suspend GetSourceControlConfigurationPlainArgsBuilder.() -> Unit): GetSourceControlConfigurationResult {
        val builder = GetSourceControlConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSourceControlConfigurationResultToKotlin(getSourceControlConfigurationPlain(builtArgument.toJava()).await())
    }
}
