@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
 */
public enum class PublicNetworkAccessType(
    public val javaValue: com.pulumi.azurenative.kubernetesconfiguration.enums.PublicNetworkAccessType,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.enums.PublicNetworkAccessType> {
    /**
     * Allows Azure Arc agents to communicate with Azure Arc services over both public (internet) and private endpoints.
     */
    Enabled(com.pulumi.azurenative.kubernetesconfiguration.enums.PublicNetworkAccessType.Enabled),

    /**
     * Does not allow Azure Arc agents to communicate with Azure Arc services over public (internet) endpoints. The agents must use the private link.
     */
    Disabled(com.pulumi.azurenative.kubernetesconfiguration.enums.PublicNetworkAccessType.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.kubernetesconfiguration.enums.PublicNetworkAccessType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.enums.PublicNetworkAccessType): PublicNetworkAccessType =
            PublicNetworkAccessType.values().first { it.javaValue == javaType }
    }
}
