@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs

import com.pulumi.azurenative.kubernetesconfiguration.inputs.GetFluxConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the kubernetes cluster.
 * @property clusterResourceName The Kubernetes cluster resource name - i.e. managedClusters, connectedClusters, provisionedClusters.
 * @property clusterRp The Kubernetes cluster RP - i.e. Microsoft.ContainerService, Microsoft.Kubernetes, Microsoft.HybridContainerService.
 * @property fluxConfigurationName Name of the Flux Configuration.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetFluxConfigurationPlainArgs(
    public val clusterName: String,
    public val clusterResourceName: String,
    public val clusterRp: String,
    public val fluxConfigurationName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.inputs.GetFluxConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesconfiguration.inputs.GetFluxConfigurationPlainArgs =
        com.pulumi.azurenative.kubernetesconfiguration.inputs.GetFluxConfigurationPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .clusterResourceName(clusterResourceName.let({ args0 -> args0 }))
            .clusterRp(clusterRp.let({ args0 -> args0 }))
            .fluxConfigurationName(fluxConfigurationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFluxConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetFluxConfigurationPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var clusterResourceName: String? = null

    private var clusterRp: String? = null

    private var fluxConfigurationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the kubernetes cluster.
     */
    @JvmName("orrnjasynlckdenv")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The Kubernetes cluster resource name - i.e. managedClusters, connectedClusters, provisionedClusters.
     */
    @JvmName("iafcvuqsrgriiunp")
    public suspend fun clusterResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterResourceName = mapped
    }

    /**
     * @param value The Kubernetes cluster RP - i.e. Microsoft.ContainerService, Microsoft.Kubernetes, Microsoft.HybridContainerService.
     */
    @JvmName("ileqcwpowskubaor")
    public suspend fun clusterRp(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterRp = mapped
    }

    /**
     * @param value Name of the Flux Configuration.
     */
    @JvmName("nbrcjxthsqfbqxtw")
    public suspend fun fluxConfigurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fluxConfigurationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jqrhkjtnmjhyobvj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetFluxConfigurationPlainArgs = GetFluxConfigurationPlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        clusterResourceName = clusterResourceName ?: throw PulumiNullFieldException("clusterResourceName"),
        clusterRp = clusterRp ?: throw PulumiNullFieldException("clusterRp"),
        fluxConfigurationName = fluxConfigurationName ?: throw
            PulumiNullFieldException("fluxConfigurationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
