@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs

import com.pulumi.azurenative.kubernetesconfiguration.inputs.GetPrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scopeName The name of the Azure Arc PrivateLinkScope resource.
 */
public data class GetPrivateEndpointConnectionPlainArgs(
    public val privateEndpointConnectionName: String,
    public val resourceGroupName: String,
    public val scopeName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.inputs.GetPrivateEndpointConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesconfiguration.inputs.GetPrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.kubernetesconfiguration.inputs.GetPrivateEndpointConnectionPlainArgs.builder()
            .privateEndpointConnectionName(privateEndpointConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .scopeName(scopeName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateEndpointConnectionPlainArgsBuilder internal constructor() {
    private var privateEndpointConnectionName: String? = null

    private var resourceGroupName: String? = null

    private var scopeName: String? = null

    /**
     * @param value The name of the private endpoint connection associated with the Azure resource
     */
    @JvmName("onxegqattnbjfsmf")
    public suspend fun privateEndpointConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xyajgdswdpexfjyl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Azure Arc PrivateLinkScope resource.
     */
    @JvmName("pajjqtfbgiffmxkf")
    public suspend fun scopeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scopeName = mapped
    }

    internal fun build(): GetPrivateEndpointConnectionPlainArgs =
        GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName ?: throw
                PulumiNullFieldException("privateEndpointConnectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            scopeName = scopeName ?: throw PulumiNullFieldException("scopeName"),
        )
}
