@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs

import com.pulumi.azurenative.kubernetesconfiguration.inputs.GetSourceControlConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the kubernetes cluster.
 * @property clusterResourceName The Kubernetes cluster resource name - i.e. managedClusters, connectedClusters, provisionedClusters.
 * @property clusterRp The Kubernetes cluster RP - i.e. Microsoft.ContainerService, Microsoft.Kubernetes, Microsoft.HybridContainerService.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sourceControlConfigurationName Name of the Source Control Configuration.
 */
public data class GetSourceControlConfigurationPlainArgs(
    public val clusterName: String,
    public val clusterResourceName: String,
    public val clusterRp: String,
    public val resourceGroupName: String,
    public val sourceControlConfigurationName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.inputs.GetSourceControlConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesconfiguration.inputs.GetSourceControlConfigurationPlainArgs =
        com.pulumi.azurenative.kubernetesconfiguration.inputs.GetSourceControlConfigurationPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .clusterResourceName(clusterResourceName.let({ args0 -> args0 }))
            .clusterRp(clusterRp.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sourceControlConfigurationName(sourceControlConfigurationName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSourceControlConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetSourceControlConfigurationPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var clusterResourceName: String? = null

    private var clusterRp: String? = null

    private var resourceGroupName: String? = null

    private var sourceControlConfigurationName: String? = null

    /**
     * @param value The name of the kubernetes cluster.
     */
    @JvmName("pehjhtacgamskutv")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The Kubernetes cluster resource name - i.e. managedClusters, connectedClusters, provisionedClusters.
     */
    @JvmName("ressgsqnmldtplcx")
    public suspend fun clusterResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterResourceName = mapped
    }

    /**
     * @param value The Kubernetes cluster RP - i.e. Microsoft.ContainerService, Microsoft.Kubernetes, Microsoft.HybridContainerService.
     */
    @JvmName("kfuunhnxnsmunpjp")
    public suspend fun clusterRp(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterRp = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qhgneslsrbdtcoks")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the Source Control Configuration.
     */
    @JvmName("jlohbkovarlambpq")
    public suspend fun sourceControlConfigurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sourceControlConfigurationName = mapped
    }

    internal fun build(): GetSourceControlConfigurationPlainArgs =
        GetSourceControlConfigurationPlainArgs(
            clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
            clusterResourceName = clusterResourceName ?: throw PulumiNullFieldException("clusterResourceName"),
            clusterRp = clusterRp ?: throw PulumiNullFieldException("clusterRp"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            sourceControlConfigurationName = sourceControlConfigurationName ?: throw
                PulumiNullFieldException("sourceControlConfigurationName"),
        )
}
