@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs

import com.pulumi.azurenative.kubernetesconfiguration.inputs.ScopeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Scope of the extension. It can be either Cluster or Namespace; but not both.
 * @property cluster Specifies that the scope of the extension is Cluster
 * @property namespace Specifies that the scope of the extension is Namespace
 */
public data class ScopeArgs(
    public val cluster: Output<ScopeClusterArgs>? = null,
    public val namespace: Output<ScopeNamespaceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.inputs.ScopeArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesconfiguration.inputs.ScopeArgs =
        com.pulumi.azurenative.kubernetesconfiguration.inputs.ScopeArgs.builder()
            .cluster(cluster?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .namespace(namespace?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ScopeArgs].
 */
@PulumiTagMarker
public class ScopeArgsBuilder internal constructor() {
    private var cluster: Output<ScopeClusterArgs>? = null

    private var namespace: Output<ScopeNamespaceArgs>? = null

    /**
     * @param value Specifies that the scope of the extension is Cluster
     */
    @JvmName("gerloijcjnndbyhm")
    public suspend fun cluster(`value`: Output<ScopeClusterArgs>) {
        this.cluster = value
    }

    /**
     * @param value Specifies that the scope of the extension is Namespace
     */
    @JvmName("sgqcplyuhyrjnlhh")
    public suspend fun namespace(`value`: Output<ScopeNamespaceArgs>) {
        this.namespace = value
    }

    /**
     * @param value Specifies that the scope of the extension is Cluster
     */
    @JvmName("xxyoqltjkeyfffrp")
    public suspend fun cluster(`value`: ScopeClusterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cluster = mapped
    }

    /**
     * @param argument Specifies that the scope of the extension is Cluster
     */
    @JvmName("xqbomtfyoaggbrnn")
    public suspend fun cluster(argument: suspend ScopeClusterArgsBuilder.() -> Unit) {
        val toBeMapped = ScopeClusterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cluster = mapped
    }

    /**
     * @param value Specifies that the scope of the extension is Namespace
     */
    @JvmName("krtgoeqgkxlfgqih")
    public suspend fun namespace(`value`: ScopeNamespaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param argument Specifies that the scope of the extension is Namespace
     */
    @JvmName("kpckmpymymjjccnr")
    public suspend fun namespace(argument: suspend ScopeNamespaceArgsBuilder.() -> Unit) {
        val toBeMapped = ScopeNamespaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.namespace = mapped
    }

    internal fun build(): ScopeArgs = ScopeArgs(
        cluster = cluster,
        namespace = namespace,
    )
}
