@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs

import com.pulumi.azurenative.kubernetesconfiguration.inputs.ServicePrincipalDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Parameters to authenticate using Service Principal.
 * @property clientCertificate Base64-encoded certificate used to authenticate a Service Principal
 * @property clientCertificatePassword The password for the certificate used to authenticate a Service Principal
 * @property clientCertificateSendChain Specifies whether to include x5c header in client claims when acquiring a token to enable subject name / issuer based authentication for the Client Certificate
 * @property clientId The client Id for authenticating a Service Principal.
 * @property clientSecret The client secret for authenticating a Service Principal
 * @property tenantId The tenant Id for authenticating a Service Principal
 */
public data class ServicePrincipalDefinitionArgs(
    public val clientCertificate: Output<String>? = null,
    public val clientCertificatePassword: Output<String>? = null,
    public val clientCertificateSendChain: Output<Boolean>? = null,
    public val clientId: Output<String>? = null,
    public val clientSecret: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.inputs.ServicePrincipalDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesconfiguration.inputs.ServicePrincipalDefinitionArgs =
        com.pulumi.azurenative.kubernetesconfiguration.inputs.ServicePrincipalDefinitionArgs.builder()
            .clientCertificate(clientCertificate?.applyValue({ args0 -> args0 }))
            .clientCertificatePassword(clientCertificatePassword?.applyValue({ args0 -> args0 }))
            .clientCertificateSendChain(clientCertificateSendChain?.applyValue({ args0 -> args0 }))
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServicePrincipalDefinitionArgs].
 */
@PulumiTagMarker
public class ServicePrincipalDefinitionArgsBuilder internal constructor() {
    private var clientCertificate: Output<String>? = null

    private var clientCertificatePassword: Output<String>? = null

    private var clientCertificateSendChain: Output<Boolean>? = null

    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Base64-encoded certificate used to authenticate a Service Principal
     */
    @JvmName("lmcfnblfxougqpmu")
    public suspend fun clientCertificate(`value`: Output<String>) {
        this.clientCertificate = value
    }

    /**
     * @param value The password for the certificate used to authenticate a Service Principal
     */
    @JvmName("kcbrougramfjuaaq")
    public suspend fun clientCertificatePassword(`value`: Output<String>) {
        this.clientCertificatePassword = value
    }

    /**
     * @param value Specifies whether to include x5c header in client claims when acquiring a token to enable subject name / issuer based authentication for the Client Certificate
     */
    @JvmName("ywyejxwpmfjhgifl")
    public suspend fun clientCertificateSendChain(`value`: Output<Boolean>) {
        this.clientCertificateSendChain = value
    }

    /**
     * @param value The client Id for authenticating a Service Principal.
     */
    @JvmName("tcscqojoitfdsenv")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The client secret for authenticating a Service Principal
     */
    @JvmName("kldxixbcnsoiqeuq")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value The tenant Id for authenticating a Service Principal
     */
    @JvmName("ocigpbaucfkiufjv")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Base64-encoded certificate used to authenticate a Service Principal
     */
    @JvmName("qdnyyucdsdowwrxq")
    public suspend fun clientCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertificate = mapped
    }

    /**
     * @param value The password for the certificate used to authenticate a Service Principal
     */
    @JvmName("eonrceidrveufukw")
    public suspend fun clientCertificatePassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertificatePassword = mapped
    }

    /**
     * @param value Specifies whether to include x5c header in client claims when acquiring a token to enable subject name / issuer based authentication for the Client Certificate
     */
    @JvmName("hnbmmdcgqmmywnul")
    public suspend fun clientCertificateSendChain(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertificateSendChain = mapped
    }

    /**
     * @param value The client Id for authenticating a Service Principal.
     */
    @JvmName("pblfjrrfifisdoog")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The client secret for authenticating a Service Principal
     */
    @JvmName("mmapglvioyjvbfrc")
    public suspend fun clientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The tenant Id for authenticating a Service Principal
     */
    @JvmName("sdvtsibdggjuywko")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): ServicePrincipalDefinitionArgs = ServicePrincipalDefinitionArgs(
        clientCertificate = clientCertificate,
        clientCertificatePassword = clientCertificatePassword,
        clientCertificateSendChain = clientCertificateSendChain,
        clientId = clientId,
        clientSecret = clientSecret,
        tenantId = tenantId,
    )
}
