@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Parameters to reconcile to the AzureBlob source kind type.
 * @property accountKey The account key (shared key) to access the storage account
 * @property containerName The Azure Blob container name to sync from the url endpoint for the flux configuration.
 * @property localAuthRef Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
 * @property managedIdentity Parameters to authenticate using a Managed Identity.
 * @property sasToken The Shared Access token to access the storage container
 * @property servicePrincipal Parameters to authenticate using Service Principal.
 * @property syncIntervalInSeconds The interval at which to re-reconcile the cluster Azure Blob source with the remote.
 * @property timeoutInSeconds The maximum time to attempt to reconcile the cluster Azure Blob source with the remote.
 * @property url The URL to sync for the flux configuration Azure Blob storage account.
 */
public data class AzureBlobDefinitionResponse(
    public val accountKey: String? = null,
    public val containerName: String? = null,
    public val localAuthRef: String? = null,
    public val managedIdentity: ManagedIdentityDefinitionResponse? = null,
    public val sasToken: String? = null,
    public val servicePrincipal: ServicePrincipalDefinitionResponse? = null,
    public val syncIntervalInSeconds: Double? = null,
    public val timeoutInSeconds: Double? = null,
    public val url: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.AzureBlobDefinitionResponse): AzureBlobDefinitionResponse = AzureBlobDefinitionResponse(
            accountKey = javaType.accountKey().map({ args0 -> args0 }).orElse(null),
            containerName = javaType.containerName().map({ args0 -> args0 }).orElse(null),
            localAuthRef = javaType.localAuthRef().map({ args0 -> args0 }).orElse(null),
            managedIdentity = javaType.managedIdentity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ManagedIdentityDefinitionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sasToken = javaType.sasToken().map({ args0 -> args0 }).orElse(null),
            servicePrincipal = javaType.servicePrincipal().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ServicePrincipalDefinitionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            syncIntervalInSeconds = javaType.syncIntervalInSeconds().map({ args0 -> args0 }).orElse(null),
            timeoutInSeconds = javaType.timeoutInSeconds().map({ args0 -> args0 }).orElse(null),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
        )
    }
}
