@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Status from the extension.
 * @property code Status code provided by the Extension
 * @property displayStatus Short description of status of the extension.
 * @property level Level of the status.
 * @property message Detailed message of the status from the Extension.
 * @property time DateLiteral (per ISO8601) noting the time of installation status.
 */
public data class ExtensionStatusResponse(
    public val code: String? = null,
    public val displayStatus: String? = null,
    public val level: String? = null,
    public val message: String? = null,
    public val time: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.ExtensionStatusResponse): ExtensionStatusResponse = ExtensionStatusResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            displayStatus = javaType.displayStatus().map({ args0 -> args0 }).orElse(null),
            level = javaType.level().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            time = javaType.time().map({ args0 -> args0 }).orElse(null),
        )
    }
}
