@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The Flux Configuration object returned in Get & Put response.
 * @property azureBlob Parameters to reconcile to the AzureBlob source kind type.
 * @property bucket Parameters to reconcile to the Bucket source kind type.
 * @property complianceState Combined status of the Flux Kubernetes resources created by the fluxConfiguration or created by the managed objects.
 * @property configurationProtectedSettings Key-value pairs of protected configuration settings for the configuration
 * @property errorMessage Error message returned to the user in the case of provisioning failure.
 * @property gitRepository Parameters to reconcile to the GitRepository source kind type.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property kustomizations Array of kustomizations used to reconcile the artifact pulled by the source type on the cluster.
 * @property name The name of the resource
 * @property namespace The namespace to which this configuration is installed to. Maximum of 253 lower case alphanumeric characters, hyphen and period only.
 * @property provisioningState Status of the creation of the fluxConfiguration.
 * @property reconciliationWaitDuration Maximum duration to wait for flux configuration reconciliation. E.g PT1H, PT5M, P1D
 * @property repositoryPublicKey Public Key associated with this fluxConfiguration (either generated within the cluster or provided by the user).
 * @property scope Scope at which the operator will be installed.
 * @property sourceKind Source Kind to pull the configuration data from.
 * @property sourceSyncedCommitId Branch and/or SHA of the source commit synced with the cluster.
 * @property sourceUpdatedAt Datetime the fluxConfiguration synced its source on the cluster.
 * @property statusUpdatedAt Datetime the fluxConfiguration synced its status on the cluster with Azure.
 * @property statuses Statuses of the Flux Kubernetes resources created by the fluxConfiguration or created by the managed objects provisioned by the fluxConfiguration.
 * @property suspend Whether this configuration should suspend its reconciliation of its kustomizations and sources.
 * @property systemData Top level metadata https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property waitForReconciliation Whether flux configuration deployment should wait for cluster to reconcile the kustomizations.
 */
public data class GetFluxConfigurationResult(
    public val azureBlob: AzureBlobDefinitionResponse? = null,
    public val bucket: BucketDefinitionResponse? = null,
    public val complianceState: String,
    public val configurationProtectedSettings: Map<String, String>? = null,
    public val errorMessage: String,
    public val gitRepository: GitRepositoryDefinitionResponse? = null,
    public val id: String,
    public val kustomizations: Map<String, KustomizationDefinitionResponse>? = null,
    public val name: String,
    public val namespace: String? = null,
    public val provisioningState: String,
    public val reconciliationWaitDuration: String? = null,
    public val repositoryPublicKey: String,
    public val scope: String? = null,
    public val sourceKind: String? = null,
    public val sourceSyncedCommitId: String,
    public val sourceUpdatedAt: String,
    public val statusUpdatedAt: String,
    public val statuses: List<ObjectStatusDefinitionResponse>,
    public val `suspend`: Boolean? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val waitForReconciliation: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.GetFluxConfigurationResult): GetFluxConfigurationResult = GetFluxConfigurationResult(
            azureBlob = javaType.azureBlob().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.AzureBlobDefinitionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            bucket = javaType.bucket().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.BucketDefinitionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            complianceState = javaType.complianceState(),
            configurationProtectedSettings = javaType.configurationProtectedSettings().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            errorMessage = javaType.errorMessage(),
            gitRepository = javaType.gitRepository().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.GitRepositoryDefinitionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            kustomizations = javaType.kustomizations().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.KustomizationDefinitionResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            name = javaType.name(),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            reconciliationWaitDuration = javaType.reconciliationWaitDuration().map({ args0 ->
                args0
            }).orElse(null),
            repositoryPublicKey = javaType.repositoryPublicKey(),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            sourceKind = javaType.sourceKind().map({ args0 -> args0 }).orElse(null),
            sourceSyncedCommitId = javaType.sourceSyncedCommitId(),
            sourceUpdatedAt = javaType.sourceUpdatedAt(),
            statusUpdatedAt = javaType.statusUpdatedAt(),
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ObjectStatusDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
            `suspend` = javaType.`suspend`().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            waitForReconciliation = javaType.waitForReconciliation().map({ args0 -> args0 }).orElse(null),
        )
    }
}
