@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The Kustomization defining how to reconcile the artifact pulled by the source type on the cluster.
 * @property dependsOn Specifies other Kustomizations that this Kustomization depends on. This Kustomization will not reconcile until all dependencies have completed their reconciliation.
 * @property force Enable/disable re-creating Kubernetes resources on the cluster when patching fails due to an immutable field change.
 * @property name Name of the Kustomization, matching the key in the Kustomizations object map.
 * @property path The path in the source reference to reconcile on the cluster.
 * @property postBuild Used for variable substitution for this Kustomization after kustomize build.
 * @property prune Enable/disable garbage collections of Kubernetes objects created by this Kustomization.
 * @property retryIntervalInSeconds The interval at which to re-reconcile the Kustomization on the cluster in the event of failure on reconciliation.
 * @property syncIntervalInSeconds The interval at which to re-reconcile the Kustomization on the cluster.
 * @property timeoutInSeconds The maximum time to attempt to reconcile the Kustomization on the cluster.
 * @property wait Enable/disable health check for all Kubernetes objects created by this Kustomization.
 */
public data class KustomizationDefinitionResponse(
    public val dependsOn: List<String>? = null,
    public val force: Boolean? = null,
    public val name: String,
    public val path: String? = null,
    public val postBuild: PostBuildDefinitionResponse? = null,
    public val prune: Boolean? = null,
    public val retryIntervalInSeconds: Double? = null,
    public val syncIntervalInSeconds: Double? = null,
    public val timeoutInSeconds: Double? = null,
    public val wait: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.KustomizationDefinitionResponse): KustomizationDefinitionResponse = KustomizationDefinitionResponse(
            dependsOn = javaType.dependsOn().map({ args0 -> args0 }),
            force = javaType.force().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            postBuild = javaType.postBuild().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.PostBuildDefinitionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            prune = javaType.prune().map({ args0 -> args0 }).orElse(null),
            retryIntervalInSeconds = javaType.retryIntervalInSeconds().map({ args0 -> args0 }).orElse(null),
            syncIntervalInSeconds = javaType.syncIntervalInSeconds().map({ args0 -> args0 }).orElse(null),
            timeoutInSeconds = javaType.timeoutInSeconds().map({ args0 -> args0 }).orElse(null),
            wait = javaType.wait_().map({ args0 -> args0 }).orElse(null),
        )
    }
}
