@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Parameters to authenticate using a Managed Identity.
 * @property clientId The client Id for authenticating a Managed Identity.
 */
public data class ManagedIdentityDefinitionResponse(
    public val clientId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.ManagedIdentityDefinitionResponse): ManagedIdentityDefinitionResponse = ManagedIdentityDefinitionResponse(
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
