@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Plan for the resource.
 * @property name A user defined name of the 3rd Party Artifact that is being procured.
 * @property product The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact at the time of Data Market onboarding.
 * @property promotionCode A publisher provided promotion code as provisioned in Data Market for the said product/artifact.
 * @property publisher The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic
 * @property version The version of the desired product/artifact.
 */
public data class PlanResponse(
    public val name: String,
    public val product: String,
    public val promotionCode: String? = null,
    public val publisher: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.PlanResponse): PlanResponse = PlanResponse(
            name = javaType.name(),
            product = javaType.product(),
            promotionCode = javaType.promotionCode().map({ args0 -> args0 }).orElse(null),
            publisher = javaType.publisher(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
