@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The postBuild definitions defining variable substitutions for this Kustomization after kustomize build.
 * @property substitute Key/value pairs holding the variables to be substituted in this Kustomization.
 * @property substituteFrom Array of ConfigMaps/Secrets from which the variables are substituted for this Kustomization.
 */
public data class PostBuildDefinitionResponse(
    public val substitute: Map<String, String>? = null,
    public val substituteFrom: List<SubstituteFromDefinitionResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.PostBuildDefinitionResponse): PostBuildDefinitionResponse = PostBuildDefinitionResponse(
            substitute = javaType.substitute().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            substituteFrom = javaType.substituteFrom().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.SubstituteFromDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
