@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The source reference for the GitRepository object.
 * @property branch The git repository branch name to checkout.
 * @property commit The commit SHA to checkout. This value must be combined with the branch name to be valid. This takes precedence over semver.
 * @property semver The semver range used to match against git repository tags. This takes precedence over tag.
 * @property tag The git repository tag name to checkout. This takes precedence over branch.
 */
public data class RepositoryRefDefinitionResponse(
    public val branch: String? = null,
    public val commit: String? = null,
    public val semver: String? = null,
    public val tag: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.RepositoryRefDefinitionResponse): RepositoryRefDefinitionResponse = RepositoryRefDefinitionResponse(
            branch = javaType.branch().map({ args0 -> args0 }).orElse(null),
            commit = javaType.commit().map({ args0 -> args0 }).orElse(null),
            semver = javaType.semver().map({ args0 -> args0 }).orElse(null),
            tag = javaType.tag().map({ args0 -> args0 }).orElse(null),
        )
    }
}
