@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies that the scope of the extension is Cluster
 * @property releaseNamespace Namespace where the extension Release must be placed, for a Cluster scoped extension.  If this namespace does not exist, it will be created
 */
public data class ScopeClusterResponse(
    public val releaseNamespace: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.ScopeClusterResponse): ScopeClusterResponse = ScopeClusterResponse(
            releaseNamespace = javaType.releaseNamespace().map({ args0 -> args0 }).orElse(null),
        )
    }
}
